;;; .emacs --- My emacs config -*- lexical-binding: t; -*-
;;; Commentary:
;;; Code:


(setq byte-compile-warnings '(cl-functions)) ;; supprime les avertissements concernant cl-libs

;; Use UTF8 everywhere, see https://thraxys.wordpress.com/2016/01/13/utf-8-in-emacs-everywhere-forever/
(setq locale-coding-system 'utf-8)
(set-terminal-coding-system 'utf-8)
(set-keyboard-coding-system 'utf-8)
(set-selection-coding-system 'utf-8)
(set-default-coding-systems 'utf-8)
(set-language-environment 'utf-8)
(prefer-coding-system 'utf-8)
(when (display-graphic-p)
  (setq x-select-request-type '(UTF8_STRING COMPOUND_TEXT TEXT STRING)))


(setq shell-file-name "/bin/bash") ;; utilise le Bourne Again Shell


;; configuration de straight
;; Bootstrap `straight.el'
(defvar bootstrap-version)
(let ((bootstrap-file
       (expand-file-name "straight/repos/straight.el/bootstrap.el" user-emacs-directory))
      (bootstrap-version 5))
  (unless (file-exists-p bootstrap-file)
    (with-current-buffer
        (url-retrieve-synchronously
         "https://raw.githubusercontent.com/raxod502/straight.el/develop/install.el"
         'silent 'inhibit-cookies)
      (goto-char (point-max))
      (eval-print-last-sexp)))
  (load bootstrap-file nil 'nomessage))

;; installation de use-package
(straight-use-package 'use-package)
(require 'package)


(use-package bind-key
  :straight t)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; Installation et configuration des paquets
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(use-package pyenv-mode
  :straight t
  :config

:init
(add-to-list 'exec-path "~/.pyenv/bin")
(add-to-list 'exec-path "~/.pyenv/shims")
(pyenv-mode t)
(pyenv-mode-set  "emacs")
  )

(use-package flycheck
  :straight t
  :config
  (setq flycheck-textlint-config "~/.config/textlint/textlintrc.json")
  (add-to-list 'flycheck-textlint-plugin-alist '(tex-mode . "latex2"))
  :init
  (add-to-list 'exec-path "~/.local/share/node_modules/.bin")
  (global-flycheck-mode))

(use-package flycheck-tip
  :straight t
  )

(use-package flycheck-grammalecte
  :straight t
  :after flycheck
  :bind
  (("C-c D" . flycheck-grammalecte-find-synonyms-at-point))
   :config
  (setq flycheck-grammalecte-report-spellcheck nil)
  (setq flycheck-grammalecte-report-grammar t)
  (setq flycheck-grammalecte-report-apos nil)
  (setq flycheck-grammalecte-report-nbsp nil)
  (setq flycheck-grammalecte-report-esp nil)
  (setq flycheck-grammalecte-filters-by-mode
        '((latex-mode
           "(?s)\\\\\\[.*?\\\\\\]"
           "\\\\label{.*?}"
           "\\\\href{.*?}"
           "(?s)\\\\begin{tikzpicture}.*?\\\\end{tikzpicture}"
           "(?s)\\\\begin{align}.*?\\\\end{align}"
           "(?s)\\\\begin{align\\*}.*?\\\\end{align\\*}"
           "(?s)\\\\begin{equation\\*}.*?\\\\end{equation\\*}"
           "(?s)\\\\begin{equation}.*?\\\\end{equation}"
            "(?s)\\\\begin{eqnarray\\*}.*?\\\\end{eqnarray\\*}"
           "(?s)\\\\begin{eqnarray}.*?\\\\end{eqnarray}"
           "(?s)\\$.*?\\$"
           "(?s)\\\\\\(.*?\\\\\\)"
           "\\\\(?:title|(?:sub)*section){([^}]+)}"
           "\\\\\\w+(?:\\[[^]]+\\])?(?:{[^}]*})?"
                                            )
          (org-mode "(?ims)^[ \t]*#\\+begin_src.+#\\+end_src"
              "(?im)^[ \t]*#\\+begin[_:].+$"
              "(?im)^[ \t]*#\\+end[_:].+$"
              "(?m)^[ \t]*(?:DEADLINE|SCHEDULED):.+$"
              "(?m)^\\*+ .*[ \t]*(:[\\w:@]+:)[ \t]*$"
              "(?im)^[ \t]*#\\+(?:caption|description|keywords|(?:sub)?title):"
              "(?im)^[ \t]*#\\+(?!caption|description|keywords|(?:sub)?title)\\w+:.*$")))

  :init

  (flycheck-grammalecte-setup)

  )

;; dictionnaire
(use-package sdcv
  :straight t
  :bind
  (("C-c e" . sdcv-search-pointer))
  :config
    (setq sdcv-dictionary-data-dir "~/.stardic/dic")
   (setq sdcv-dictionary-simple-list    ;setup dictionary list for simple search
       '("XMLittre"
         ))
 (setq sdcv-dictionary-complete-list     ;setup dictionary list for complete search
       '(
         "XMLittre"
  ;       "dictd_www.dict.org_gcide"
  ;       "Dictionnaire de l’Académie Française, 8ème édition (1935)."
         ))
  )
