#!/usr/bin/python
# -*- coding: utf-8 -*-

# attention_lettre.py
# Copyright 2011 V. Ledda
# Contact: v.ledda@laposte.net

#  This file is part of attention_lettre.py.

#     attention_lettre.py is free software: you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation version 2.
    
#     attention_lettre.py is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.

#     You should have received a copy of the GNU General Public License
#     along with attention_lettre.py.  If not, see
#     <http://www.gnu.org/licenses/>.




from sys import *
import random
import string
import time
#import re
numero=time.strftime("%s",time.gmtime())[-6:]
print "\\documentclass[A4,12pt]{cueep_xe}\n\\usepackage{fontspec}\n\\setmainfont{TeX Gyre Schola}\n\\newfontfamily\\textarcc{Arrows}\n\\newcommand{\\textarc}[1]{{\\Huge \\textarcc #1}}\n\\titre{Test d'observation}\n\\reference{n°"+numero+"}\n\\begin{document}\n"

#Pour flèches courbes
#alphabet="ijklmnop"


#Pour flèches obliques
alphabet="abcdefgh"

lalpha=len(alphabet)


def reponse(rep):
    position=random.randint(0,4)
    liste=range(max(rep-position,0),max(rep-position,0)+5)
    s="\\begin{qcm}"
    for i in liste:
        s+="\\item "+str(i)
    return s+"\\end{qcm}\n"

def cherche_bigramme(texte):
    bigrammes={texte[0:2]:1}
    l=len(texte)
    for i in range(2,l):
        o=texte[i-1]
        t=texte[i]
        if (t != "\n") and (o != "\n"):
            d=o+t
            if d in bigrammes.keys():
                bigrammes[d]=bigrammes[d]+1
            else:
                bigrammes[d]=1
    return bigrammes

def modes_diagramme(bigramme):
    r={'p':[0,[]],'d':[0,[]],'t':[0,[]]}
    m=0
    while len(bigramme):
        paire=bigramme.popitem()
        score=paire[1]
     
        if score>m:
            r['t']=r['d']
            r['d']=r['p']
            r['p']=[score,[paire[0]]]
            m=score
        elif score==m:
            r['p'][1].append(paire[0])
        elif score==m-1:
            r['d'][1].append(paire[0])
        elif score==m-2:
            r['t'][1].append(paire[0])
     
    return r

def nb_lettre_l68(lignes,lettre):
    s=0
    for i in range(5,8):
        s+=lignes[i].count(lettre)
    return s

random.seed()

l=10
N=25




lignes=[]

for i in range(l):
    ligne=""
    for j in range(N):
        ligne+=alphabet[random.randint(0,lalpha-1)]
    
    lligne=list(ligne)
    
    lignes.append("".join(lligne))





text=""
for ligne in lignes:
    text+=ligne+"\n"



#print "Soit l'ensemble de "+str(l*N)+" lettres rangées par lignes de "+str(N)+" apparaissant dans un ordre aléatoire:"
print "\\begin{center}\\ttfamily\\begin{tabular}[h]{cl}\n"
for i in range(l):
    print str(i+1)+"&\\textarc{"+lignes[i]+"}\\\\"

print "\\end{tabular}\\end{center}\\qcmTexte{}\\qcmAlpha"



reponses=[]

print "\\begin{Qcm}[5]"
## question 1
lettre=lignes[0][random.randint(0,N-1)]
rtmp=lignes[0].count(lettre)

print "\\item Combien y a-t-il de \\textbf{\\textarc{"+lettre+"}} surla première ligne?"
print reponse(rtmp)
reponses.append(rtmp)




##question 2
lettre=lignes[l-2][random.randint(0,N-1)]
rtmp=lignes[l-2].count(lettre)

print "\\item Combien y a-t-il de \\textbf{\\textarc{"+lettre+"}} sur l'avant dernière ligne?"
print reponse(rtmp)
reponses.append(rtmp)




##question 3
lettre=lignes[7][random.randint(0,N-1)]

rtmp=nb_lettre_l68(lignes,lettre)



print "\\item Combien y a-t-il de \\textbf{\\textarc{"+lettre+"}} sur les lignes 6, 7 et 8?"

print reponse(rtmp)
    
reponses.append(rtmp)



##question 4
ligne=random.randint(1,5)
s=0
for i in range(0,lalpha-1):
    lettre=alphabet[i]
    s+=lignes[ligne-1].count(lettre+lettre)
print "\\item Combien y a-t-il de couples de symboles identiques sur la ligne "+str(ligne)+"?"
print reponse(s)



reponses.append(s)


##question 5

s=0
for i in range(0,lalpha-1):
    lettre=alphabet[i]
    for j in range(l):
        s+=lignes[j].count(lettre+lettre+lettre)
print "\\item Combien y a-t-il de triplet de symboles identiques sur la totalité du texte?"
print reponse(s)


reponses.append(s)




##question 7 

bigramme_a=modes_diagramme(cherche_bigramme(text))

#print bigramme_a
s=bigramme_a['d'][0]
reponses.append(s)

bigramme=bigramme_a['d'][1].pop(random.randint(0,len(bigramme_a['d'][1])-1))

print "\\item Combien y a-t-il de \\textarc{"+bigramme+"} dans le texte?"
print reponse(s)





print "\\end{Qcm}\\pagebreak\\begin{center}{\Huge Réponses}\\end{center}"
#print "\\begin{tabular}[h]{cc}"
#for i in alphabet:
#    print i+"&\\textarc{"+i+"}\\\\"
#  
#print "\\end{tabular}"


print "\\begin{enumerate}"
for i in reponses:
    print "\\item "+str(i)

print "\\end{enumerate}\n"

print "\\end{document}"
