#!/usr/bin/python 
# -*- coding: iso-8859-1  -*-
############### import #################
import sys
import types
from xml.dom.ext.reader.Sax import FromXmlFile
import re
from string import split
import os
import posix

################ fonctions utilitaires ########
def chaine2listedentier(liste):
    return map(int,split(liste[1:-1],','))

def chaine2liste(liste):
    return split(liste[1:-1],',')

testliste=re.compile('^\[')
testempty=re.compile('_')
def chercher(nom):
    sortie=[]
    for noeu in nom:
        try:
            tmp = noeu.childNodes[0].nodeValue
            if testliste.match(tmp):
                sortie.append(chaine2liste(tmp))
            else:
                sortie.append(tmp)
        except IndexError:
            if noeu.nodeName == 'valeur':
                sortie.append('')
            pass
    return sortie


def somme_liste(liste):
    sortie=0
    for i in liste:
        sortie=sortie+i
    return sortie

def trouve_liste(liste,objet):
    sortie=''
    j=0
    for i in liste:
        if i[0] == objet:
            return [j]
        j=j+1
    return sortie

###################### classe crayon ##########################
class crayon:
    def trait(self,x1,y1,x2,y2):
        return 'draw ('+str(x1)+'u,'+str(y1)+'u) -- ('+str(x2)+'u,'+str(y2)+'u);\n'
    def tiret(self,x1,y1,x2,y2):
        return 'draw ('+str(x1)+'u,'+str(y1)+'u) -- ('+str(x2)+'u,'+str(y2)+'u) dashed evenly scaled 2;\n'
    def rectangle(self,x1,y1,x2,y2):
        return 'draw ('+str(x1)+'u,'+str(y1)+'u) -- ('+str(x2)+'u,'+str(y1)+'u) -- ('+str(x2)+'u,'+str(y2)+'u) -- ('+str(x1)+'u,'+str(y2)+'u) -- cycle ;\n'
    def Label(self,label,x,y):
        if testempty.search(label):
            s=''
        else:
            s='label(btex '+label+' etex, ('+str(x)+'u,'+str(self.hauteurT-y)+'u));\n'
        return s

    def croix(self,x,y):
        return 'draw ('+str(x+taille_signe)+'u,'+str(self.hauteurT-y)+'u) -- ('+str(x-taille_signe)+'u,'+str(self.hauteurT-y)+'u); draw ('+str(x)+'u,'+str(self.hauteurT-y+taille_signe)+'u) -- ('+str(x)+'u,'+str(self.hauteurT-y-taille_signe)+'u);\n'

    def moins(self,x,y):
        return 'draw ('+str(x+taille_signe)+'u,'+str(self.hauteurT-y)+'u) -- ('+str(x-taille_signe)+'u,'+str(self.hauteurT-y)+'u);\n'

   
    
    def fleche(self,x,y,z,t):
        return 'drawarrow ('+str(x)+'u,'+str(self.hauteurT-y)+'u)..('+str(z)+'u,'+str(self.hauteurT-t)+'u);\n'


###################### classe principale ####################################
###################### je sais je devrais faire d'autres objets ... ########

class tableau(crayon):
    def __init__(self,longueur,hauteur):
        self.longueur=longueur
        self.hauteur=hauteur
        sortie.write('verbatimtex\n\t\\documentclass{article}\n\t\\usepackage[intlimits]{amsmath}\n\t\\usepackage{amsfonts}\n\t\\usepackage{lmodern}\n\t\\begin{document}\netex\nbeginfig(1);u=1cm;defaultscale := 1.2;\n')
        self.longueurT=self.longueur+taille_Pcol
        self.hauteurT=taille_premiere_ligne+round(somme_liste(self.hauteur),3)

    def signe(self,label,x,y):
        if label == '-':
            s = self.moins(x,y)
        elif label == '+':
            s = self.croix(x,y)
        elif label == '_':
            s = ''
        return s     
    
    def variations(self,valeurs,positions,liste,i):
        print "dbut variation"
        print valeurs
        print positions
        print liste
        print i
        base=0
        for k in range(max(0,i)):
           base=base+liste[k]
        k=0
        
        while k < len(valeurs)-1:
            positionI=positions[2*k]
            positionF=positions[2*k+2]
            xI=valeurs[k][1]
            xF=valeurs[k+1][1]
            sortie.write(self.Label(valeurs[k][0],xI,base+self.calculs_position(i,liste,positionI)))
            
            if positions[2*k+1] == 1:
                if positionI == positionF:
                    epsilon=0
                elif positionI > positionF:
                    epsilon = -1
                else:
                    epsilon = 1
                yI= base - epsilon*liste[i]/15.0 + liste[i]*(7.5+(100-positionI)*85/100.0)/100
                yF= base + epsilon*liste[i]/15.0 + liste[i]*(7.5+(100-positionF)*85/100.0)/100
                xI=xI + 1*self.Le 
                xF=xF - 1*self.Le 
                sortie.write(self.fleche(xI,yI,xF,yF))
            k=k+1
        k=len(valeurs)-1
        sortie.write(self.Label(valeurs[k][0],valeurs[k][1],base+self.calculs_position(i,liste,positions[2*k])))


    def test(self,label,x,y):
        sortie.write(self.Label(label,x,y))
        
    def calculs_ecarts(self,i,liste):
        h=0
        for j in range(max(0,i)):
           h=h+round(liste[j],3)
        return  h+liste[i]/2.0  

    def calculs_position(self,i,liste,coeff):
        return  liste[i]*(7.5+(100-coeff)*85/100.0)/100
    
    def calculs_hauteurdb(self,indice):
        h=0 
        k=0
        while k <= indice:
            h=h+self.hauteur[k]
            k=k+1
        return h
           
    def remplir(self,tableau_type,Pcol,Ldroite,Lgauche,Elements,EntreE,double_barre,filet):
        self.Pcol=Pcol
        self.Ldroite=Ldroite
        self.Lgauche=Lgauche
        self.Elements=Elements
        self.DB=double_barre
        self.FL=filet
        self.EntreE=EntreE
        self.Elements_nombre=len(self.Elements)
        #place pour les limites, les lments et entre les lments
        self.Ll=self.longueur/10.0
        self.Le=self.Ll/2
        self.d=self.longueur*(16-self.Elements_nombre)/(self.Elements_nombre+1)/20.0
        ########Sparation des type de lignes #######################
        self.Ttype=tableau_type
        self.facile=[0]
        self.difficile=[]
        self.vide=[]
        self.valeursvide=[]
        j=1
        for i in self.Ttype:
            if i == 'signe':
                self.facile.append(j)
            elif i == 'variations':
                self.difficile.append(j)
            elif i == 'vide':
                self.vide.append(j)
            elif i == 'valeursvide':
                self.valeursvide.append(j)
            j=j+1
        ############# Calcul des espaces horizontaux ######################    
        self.espace=[]    
        for i in range(self.Elements_nombre):
            self.espace.append(taille_Pcol+self.Ll+(i+1)*(self.Le/2.0+self.d)+i*self.Le/2.0)

        self.entreE=[]
        for i in range(self.Elements_nombre+1):
            self.entreE.append(taille_Pcol+self.Ll+i*(self.Le+self.d/2.0)+(i+1)*self.d/2.0)

    def debug(self):
        print  self.Ldroite
        print self.Lgauche
        print self.Elements
        print self.DB
        print self.EntreE
        print self.Ttype
        print self.hauteur
        print self.hauteurT
        
    def doubleB(self):
        for i in self.DB:
            if self.Lgauche[0] == i[0]:
                x=taille_Pcol+self.Le
            elif self.Ldroite[0] == i[0]:
                x=self.longueurT-self.Le
            else:
                t=trouve_liste(self.Elements,i[0])
                if t :
                    x=self.espace[t[0]]
            xd=x+self.Ll/20
            xg=x-self.Ll/20
            yh=self.calculs_hauteurdb(i[1]-1)
            yb=self.calculs_hauteurdb(i[2])
         
            sortie.write(self.trait(xd,self.hauteurT-yh,xd,self.hauteurT-yb))
            sortie.write(self.trait(xg,self.hauteurT-yh,xg,self.hauteurT-yb))
            
    def filet(self):
        for i in self.FL:
            if self.Lgauche[0] == i[0]:
                x=taille_Pcol+self.Le
            elif self.Ldroite[0] == i[0]:
                x=self.longueurT-self.Le
            else:
                t=trouve_liste(self.Elements,i[0])
                if t :
                    x=self.espace[t[0]]
            yh=self.calculs_hauteurdb(i[1]-1)
            yb=self.calculs_hauteurdb(i[2])
         
            sortie.write(self.tiret(x,self.hauteurT-yh,x,self.hauteurT-yb))


            
    def tracer_tableau(self):
        ####################### Les traits du tableau ##########################
        sortie.write(self.rectangle(0,0,self.longueurT,self.hauteurT))
        sortie.write(self.trait(taille_Pcol,0,taille_Pcol,self.hauteurT))
        i=taille_premiere_ligne
        sortie.write(self.trait(0,self.hauteurT-i,self.longueurT,self.hauteurT-i))
        for j in self.hauteur:
            i=i+round(j,3)
            sortie.write(self.trait(0,self.hauteurT-i,self.longueurT,self.hauteurT-i))

       
        
        ###################### la premire colonne et les limites des lignes faciles ##############
        self.hauteur.insert(0,taille_premiere_ligne)
        for i in self.facile+self.valeursvide:
            h=self.calculs_ecarts(i,self.hauteur)
            sortie.write(self.Label(self.Pcol[i],taille_Pcol/2.0,h))
            sortie.write(self.Label(self.Lgauche[i],taille_Pcol+self.Ll/2,h))
            sortie.write(self.Label(self.Ldroite[i],self.longueurT-self.Ll/2,h))
     

        #################### lments de la premire ligne #############
        h=self.calculs_ecarts(0,self.hauteur)
        for j in range(self.Elements_nombre):
            sortie.write(self.Label(self.Elements[j][0],self.espace[j],h))


     
        ############  et des lignes faciles #################
        del self.facile [0]
        print self.facile
        print self.Elements
        print self.EntreE
        for i in self.facile:
            h=self.calculs_ecarts(i,self.hauteur)
            for j in range(self.Elements_nombre):
                print "indice",i,j
                sortie.write(self.Label(self.Elements[j][i],self.espace[j],h))
                sortie.write(self.signe(self.EntreE[i-1][j],self.entreE[j],h))
            sortie.write(self.signe(self.EntreE[i-1][self.Elements_nombre],self.entreE[self.Elements_nombre],h))
        ##################### difficile ####################################
        
        for i in self.difficile:
            sortie.write(self.Label(self.Pcol[i],taille_Pcol/2.0,self.calculs_ecarts(i,self.hauteur)))
            ######## On rempli le tableau valeurs avec les abscisses
            valeurs=[]
            ######## limite  gauche ###########
            t=trouve_liste(self.DB,self.Lgauche[i])
            if t :
                valeurs.append([self.Lgauche[i],taille_Pcol+2*self.Le])
            else:
                valeurs.append([self.Lgauche[i],taille_Pcol+self.Ll/2])
            ######## Entre les limites #########
            chouia=1*self.Le
            print self.Elements
            for j in range(self.Elements_nombre):
                print "i",i
                print "j",j
                print self.Elements[j][i]
                if type(self.Elements[j][i]) == types.ListType:
                    x=self.espace[j]-chouia
                    for val in  self.Elements[j][i]:
                        if val != '':
                           valeurs.append([val,x])
                        x=x+chouia
                elif self.Elements[j][i] != 'null':
                    valeurs.append([self.Elements[j][i],self.espace[j]])
            ######## limite  droite ###########
            t=trouve_liste(self.DB,self.Ldroite[i])
            if t :
                valeurs.append([self.Ldroite[i],self.longueurT-self.Ll])
            else:
                valeurs.append([self.Ldroite[i],self.longueurT-self.Ll/2])
            self.variations(valeurs,self.EntreE[i-1],self.hauteur,i)
        
        self.doubleB()
        self.filet()
              

            
    def fin(self):
        sortie.write('endfig;end;')
        sortie.close()


######################################################################################
#####################################################################################


################## traitement des arguments ##################################


if len(sys.argv) == 2:
    basename=split(sys.argv[1],'.')[0]
    sortie=open(basename+'.mp','w')
elif len(sys.argv) == 3:
    sortie=open(sys.argv[2],'w')
else:
    print " USAGE: tableaux.py entree [sortie]"
    print " AIDE sur la syntaxe du fichier d'entre"
    print "Pour les noeux Pcol, limitegauche, limitedroite, element"
    print "la premire valeur est la valeur de la ligne d'entte"
    print ""
    print "pour le noeux <element>,"
    print "une valeur:"
    print "vide corespond  une valeur vide dans le tableau"
    print "null correspond  l'absence de valeur pour les lignes de variations"
    print "[gauche,centree,droite] corespond  des valeurs centres sur l'lment  pour les lignes de variations" 
    print ""
    print "pour le noeu <entreElements> deux types: "
    print "signe"
    print "o l'on rempli des signes  + et - les espaces entre les lments"
    print "ex: [+,-,+,-]"
    print "variations"
    print " la syntaxe est un peu obscure..."
    print "les numros de rang pair sont des entiers compris entre 0 et 100, correspondent"
    print " la positions des lments dans la ligne de variations"
    print "0 tant la position la plus basse..."
    print "les numros de rang impaire sont des 0 ou des 1, 0 correspondant  l'abscence de flche..."
    print "exemple: [10,0,50,1,100] lment position 10, pas de flche, un autre au milieu, une flche, et un dernier lment en haut"
    print "Attention il faut tenir compte des valeurs null et des [ , , ] qui influent sur le nombre"
    print "d'lment de cette ligne de variations"
    print ""
    print "le noeu <refElement> dans <barre> correspond  l'lment o est centr une double barre,"
    print "le noeu <debut> et le noeu <fin> correspondent aux lignes de dbut et de fin de la double barre"
    sys.exit(1)
    
entree=FromXmlFile(sys.argv[1])
#entree=FromXmlFile('test.xml')
#sortie=open('test.mp','w')


####################### lecture du fichier d'entree ############################
#le parseur est pourri il faut pouvoir dtecter les erreurs de syntaxe
#Premire colonne
PCOL=entree.getElementsByTagName('PCol')
premiere_colonne=chercher(PCOL[0].childNodes)

#limite droite
limite_droite=chercher(entree.getElementsByTagName('limitedroite')[0].childNodes)

#limite gauche
limite_gauche=chercher(entree.getElementsByTagName('limitegauche')[0].childNodes)

#elements
elements=[]
for noeux in entree.getElementsByTagName('element'):
    elements.append(chercher(noeux.childNodes))
print "Elements\n",elements
#entreElements
Ttype=[]
entreElements=[]
hauteur_ligne=[]
testplusmoins=re.compile('\+|\-|_')
for noeux in entree.getElementsByTagName('entreElements')[0].childNodes:
    try:
        for noeu in noeux.attributes:
            if noeu.nodeName == "hauteur":
                hauteur_ligne.append(float(noeu.nodeValue))
            elif noeu.nodeName == "type":
                Ttype.append(noeu.nodeValue)
                if noeu.nodeValue == "vide":
                    entreElements.append([])
                if noeu.nodeValue == "valeursvide":
                    entreElements.append([])
    except TypeError:
        pass
    try:
        tmp=noeux.childNodes[1].childNodes[0].nodeValue
        if testplusmoins.search(tmp):
            entreElements.append(chaine2liste(tmp))
        else:
            entreElements.append(chaine2listedentier(tmp))

    except IndexError:
        pass



#bouble barre
dbar=[]
for noeux in entree.getElementsByTagName('doubleBarre')[0].childNodes:
    try:
        tmp=['','','']
        for noeu in noeux.childNodes:
            if noeu.nodeName == 'refElement':
                tmp[0]=noeu.childNodes[0].nodeValue
            elif noeu.nodeName == 'debut':
                tmp[1]=int(noeu.childNodes[0].nodeValue)
            elif noeu.nodeName == 'fin':
                tmp[2]=int(noeu.childNodes[0].nodeValue)
        if tmp != ['','','']:
            dbar.append(tmp)
    except IndexError:
        pass
    
#filet 
filet=[]
for noeux in entree.getElementsByTagName('filet')[0].childNodes:
    try:
        tmp=['','','']
        for noeu in noeux.childNodes:
            if noeu.nodeName == 'refElement':
                tmp[0]=noeu.childNodes[0].nodeValue
            elif noeu.nodeName == 'debut':
                tmp[1]=int(noeu.childNodes[0].nodeValue)
            elif noeu.nodeName == 'fin':
                tmp[2]=int(noeu.childNodes[0].nodeValue)
        if tmp != ['','','']:
            filet.append(tmp)
    except IndexError:
        pass
    
#tableau
optionTableau={}
for i in entree.getElementsByTagName('tableau')[0].attributes:
    optionTableau[i.name]=i.value


######################## le programme proprement dit:
## print "#########################################################"
## print "premiere colonnne",premiere_colonne
## print "limite_droite",limite_droite
## print "limite_gauche",limite_gauche
## print "elements",elements
## print "type",Ttype
## print "taille",hauteur_ligne
## print "entreElements", entreElements
##print "db",dbar
## print "options", optionTableau
## print "#########################################################"
## print "taille signe",float(optionTableau['taille_signe'])
## print "taille 1 ligne", float(optionTableau['taille_P_ligne'])
## print "taille 1 colonne",float(optionTableau['taille_P_colonne'])
## print "longeur",float(optionTableau['longueur'])
## print "#########################################################"

taille_signe=float(optionTableau['taille_signe'])
taille_premiere_ligne=float(optionTableau['taille_P_ligne'])
taille_Pcol=float(optionTableau['taille_P_colonne'])

exemple=tableau(float(optionTableau['longueur']),hauteur_ligne)

exemple.remplir(Ttype,premiere_colonne,limite_droite,limite_gauche,elements,entreElements,dbar,filet)

exemple.debug()
exemple.tracer_tableau()
exemple.fin()

###### traitement du fichier metapost et cration du eps#######
os.system('mpost --tex latex '+basename+'.mp')
latex=open('tmp.tex','w')
latex.write('\\documentclass[A4]{exo}\n\\begin{document}\\includegraphics{'+basename+'.1}\n\\end{document}')
latex.close()
os.system('latex tmp.tex && dvips -t a4  -f tmp.dvi > tmp.ps && convert -density 150x150 -crop 0x0 tmp.ps '+basename+'_v.eps && mv '+basename+'.1 '+basename+'.eps && rm -f tmp.tex tmp.ps tmp.dvi ')

            
## type_ligne=['signe','variations','signe','variations']
## premiere_ligne=['$x$',"$f'(x)$","f(x)","g'(x) = f(x)","$g(x)$"]
## limite_droite=['$+\infty$','','$-4$','','$5$']
## limite_gauche=["$-\infty$",'','','','$7$']
## dbar=[['$-\\infty$',1,2]]
## #dbar=[["$-\infty$",1,2],["$\\alpha$",4,4],["$1$",2,2],["$\\alpha$",2,2],["$1$",4,4]]
## #elements=[['$1$','$0$','','$0$',['$5$','','$-5$']] , ["$\\alpha$",'$0$','','$4$',['$+\infty$','','$-\infty$']],['$\sqrt{3}$','','$g(\sqrt{3})$','$0$','$\\beta$']]
## elements=[['$\\alpha$','1','null','$0$','$2+\sqrt{35}$']]
## #reste=[['+','-','+','-'], [0,1,100,1,0,1,100,1,0],['+','+','-','-'],[0,1,100,0,0,1,100,0,0,1,75,1,100]]
## reste=[['+','+'],[0,1,100],['-','+'],[19,1,65,0,30]]
## exemple1=tableau(10,[1,4,1,4])
## exemple1.remplir(type_ligne,premiere_ligne,limite_droite,limite_gauche,elements,reste,dbar)
## exemple1.tracer_tableau()
## exemple1.fin()
