% exos.sesamath.net
% Copyright 2005 sesamath
% Contact : vincent.ledda@sesamath.net
     
% This file is part of exos.sesamath.net.

% exos.sesamath.net is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% (at your option) any later version.

% exos.sesamath.net is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with exos.sesamath.net; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{sesabac}[2004/29/10 v0.2 Une classe pour des exos de math du site ssabac]

%%%%%%%%%%%%
% Option   %
%%%%%%%%%%%%

\RequirePackage{ifpdf}  % pour separer les options pdf et ps




% des options  dclarer , celles inconnues sont
% passees  la classe article

%\DeclareOption{test}{\@testtrue}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}

% options pour des packages
\ifpdf
  \PassOptionsToPackage{pdftex,pdfstartview=FitH}{hyperref}
  \PassOptionsToPackage{pdftex}{geometry}
  \PassOptionsToPackage{pdftex}{color}
  \PassOptionsToPackage{pdftex}{graphicx}
  
\else
  \PassOptionsToPackage{dvips}{hyperref}
  \PassOptionsToPackage{dvips}{geometry}
  \PassOptionsToPackage{dvips}{color}
  \PassOptionsToPackage{dvips}{graphicx} 
\fi 



%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Dimensions et compteurs
%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcount\referenc

%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Options de la classe
%%%%%%%%%%%%%%%%%%%%%%%%%%%


\DeclareOption{reference}{%
\referenc= 1
}





\ProcessOptions\relax











\LoadClass{article}
 

%%%%%%%%%%%%
%Dpendances
%%%%%%%%%%%%


\RequirePackage[latin1]{inputenc} % rmq : est-ce compatible avec les macounets ?
\RequirePackage[T1]{fontenc}

\ifpdf
\usepackage{lmodern} % fonte vectorielle
\fi


%%% -- MODIF -- %%%

% en lisant le topic de ce fil : on met le minimum et on rajoutera si besoin 

%\RequirePackage{eurosym,fancybox,vmargin,multicol,ifthen,keyval,pst-plot}
%\RequirePackage{url,mdwlist,pifont,array,calc,epsfig,amsmath,amssymb,picins,graphics,textcomp,color}


%
% pour des raisons de compatibilites, certains packages
% doivent etre appeles avant d'autres (voir numero dans ce cas)
%

\RequirePackage{%
 ifthen,   % pour les conditions ( pour les macros )
 amsmath,  % les commandes maths
 amssymb,  % symboles maths
 array,    % gestion des tableaux
 multirow, % gestion des tableaux sur plusieurs lignes
 slashbox, % tableaux : barre diagonale dans une cellule
	   % exple: \backslashbox{toto}{tata}
 colortbl, % tableaux : couleur (entre autre grise les cellules)
           % exple: cell1 & \cellcolor[gray]{0.8} cell2 & cell3 
 pst-plot, % faire des dessins en pstricks
%  url,      % pour taper correctement les url exple: \url{}
             % appele par hyperref           
 eurosym } % le symbole euro \texteuro

 
\RequirePackage{multicol}         % pour le multicolonnage
                                  % exple : \begin{multicols}{2}
% \setlength{\columnseprule}{0.1pt} % separation par un trait vertical 
                                  % de chaque colonne

\RequirePackage[flushleft, alwaysadjust]{paralist} 
                                  % configure les environnements de liste
\setdefaultenum{}{a.}{}{}         % numerotations des items


\RequirePackage{fancyhdr}         % entete et bas de page Cf style.tex


\RequirePackage[frenchb]{babel}

\RequirePackage[pdftitle={sesabac},%
                colorlinks=true,%
                linkcolor=black,%
                urlcolor=blue]{hyperref} % (20)

\RequirePackage[hmargin=1cm, vmargin=1cm]{geometry}% (25) format de la page
%\geometry{hmargin=3cm, vmargin=3cm }


\RequirePackage{color,graphicx}          % (30)    gestion des figures 
                                         % (plus d'options que graphics)



\input{style_sesabac}      % definie les variables des environnements, l'entete et le bas de page
\input{environ_sesabac}    % dfini les environnements
\input{macro_sesabac}      % macro pour des commandes usuelles
\input{tabvar}     % pour les tableaux de signes et variations de D. Leger
                   % http://membres.lycos.fr/leger/tex/
