<?php
/*
    exos.sesamath.net
    Copyright 2006 sesamath
    Contact : vincent.ledda@sesamath.net
    
    This file is part of exos.sesamath.net.

    exos.sesamath.net is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    exos.sesamath.net is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with exos.sesamath.net; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



function annee($connexion)
  //renvoie les diffÃ©rentes annÃ©es oÃ¹ des sujets existent

{
  $s=array();
  $resultat=ExecRequete("SELECT DISTINCT annee FROM BAC ORDER BY annee",$connexion);
  while($tmp=LigneSuivante($resultat))
    {
      $s[]=$tmp->annee;
    }
  return $s;
}
function frise($annee)
  //renvoie du code html avec une jolie frise

{
  $s='<p class="frise">'."\n\t";
  for ($i=0; $i< count($annee); $i++)
    {
      $s .= '<span class="frise"><a href="index.php?annee='.$annee[$i].'">'.$annee[$i].'</a></span>';
    }
  $s .="\n</p>";
  return $s;
}

function menu_serie($connexion)
//renvoie du code html pour le menu

{
  $s='<select size="1" id="choixserie" name="choixserie" onchange="submit()">'."\n <option>---------</option>\n";
  $r="SELECT DISTINCT id_niveau,serie FROM niveau,BAC WHERE ref_id_serie=id_niveau";
 
  $resultat=ExecRequete($r,$connexion);
  while($tmp=LigneSuivante($resultat))
    {
	$s.='<option label="'.$tmp->serie.'"value="'.$tmp->id_niveau.'">'.$tmp->serie.'</option>'."\n";
      }
  $s.=" </select>\n";
  $s .='<input type="submit"  value="go" name="entree"/>';
  return $s;
}
function ecrire_frise($connexion)
  //ecrit la frise sur le disque
{
  $fh = fopen('templates/frise.tpl','w');
  fputs($fh,frise(annee($connexion)));
  $fc=fclose($fh);
}

function ecrire_menu_serie($connexion)
  //ecrit  menu_serie  sur le disque
{
  $fh = fopen('templates/menu_serie.tpl','w');
  fputs($fh,menu_serie($connexion));
  $fc=fclose($fh);
}

function nomserie($id_niveau,$connexion)
//return le nomd'une sÃ©rie
{
  $resultat=ExecRequete("SELECT serie FROM niveau WHERE id_niveau='$id_niveau'",$connexion);
  $tmp=LigneSuivante($resultat);
  return $tmp->serie;
}
function idserie($serie,$connexion)
//return l'id 'une sÃ©rie
{
  $resultat=ExecRequete("SELECT id_niveau FROM niveau WHERE serie='$serie'",$connexion);
  $tmp=LigneSuivante($resultat);
  return $tmp->id_niveau;
}

function mois($n)
//revoie le mois en toute lettre
{
  $t=array("0"=>"","6"=>"juin","9"=>"septembre","4"=>"avril","3"=>"mars","10"=>"octobre","5"=>"mai");
  return $t[$n];
}

function idmois($mois)
//revoie le mois en chiffre
{
  $t=array("Juin"=>"6","Septembre"=>"9","Avril"=>"4","Mars"=>"3","Octobre"=>"10");
  return $t[$mois];
}

function centre($i,$connexion)
//revoie le centre en toute lettre 
// Ã  modifier pour des noms + joli!
{
  $resultat=ExecRequete("SELECT centre FROM centre WHERE id_centre='$i'",$connexion);
  $tmp=LigneSuivante($resultat);
  return $tmp->centre;
}
function idcentre($centre,$connexion)
//revoie le centre en toute lettre 
// Ã  modifier pour des noms + joli!
{
  $resultat=ExecRequete("SELECT id_centre FROM centre WHERE centre_abr='$centre'",$connexion);
  $tmp=LigneSuivante($resultat);
  return $tmp->id_centre;
}

function delete(&$i)
{
  if(isset($i))
    {
      unset($i);
    }
}

function nb_exo($centre,$mois,$annee,$serie,$connexion)
{
  $total=0;
  $r="SELECT DISTINCT COUNT('id_bac') as nombre FROM BAC,niveau WHERE ref_id_centre='$centre' AND annee='$annee'  AND serie='$serie' AND ref_id_serie=id_niveau";
  $resultat=ExecRequete($r,$connexion);
  while($tmp=LigneSuivante($resultat))
    {
      $total=$tmp->nombre;
    }
  return $total;
}

function pourcentage_swf($total,$nom,$connexion)
{
 
  $nb=intval(exec("ls sujets/swf/".$nom."*  |wc|awk '{print $1}'")) ;
 
  $f=1.0*$nb/($total+1);
  if( $f == 0)
    {
      $s=0;
    }
  
  elseif( $f <0.5)
    {
      $s=25;
    }
  elseif($f < 0.75)
    {
      $s=50;
    }
   elseif($f < 1.0)
    {
      $s=75;
    }
   else
     {

       $s=100;
     }
  return $s;
  

		  



}

function lien_swf($nom,$pourcentage)
{
 
  if( $pourcentage > 0)
    {
      if( $pourcentage == 100)
	{
	  $image="oui";
	}
      elseif (	$pourcentage == 0)
	{
	  $image="non";
	}
      else
	{
	  $image="oui".$pourcentage;
	}
      $s = '<a  href="sujets/swf/'.$nom.'_menu.swf" type="application/x-shockwave-flash"><img class="lien" src="images/'.$image.'.png" alt="disponible à '.$pourcentage.' %"/>';
    }
  else
  {
    $s='<img src="images/non.png" alt="indisponible"/>';
  }
 return $s;

}


function lien($nom,$mime="application/pdf")
{
  if(file_exists($nom))
    {
      $s='<a  href="'.$nom.'" type="'.$mime.'"><img class="lien" src="images/oui.png" alt="disponible"/></a>';
    }
  else
  {
    $s='<img src="images/non.png" alt="indisponible"/>';
  }
  return $s;
}

function nom_to_info($nom)
{
  $r="/(S|ES|L|STT|STG)(Juin|Mars|Mai|Septembre|Novembre)([\d]{4,4})(FR| RE|AS|NC|PY|AG|PO|LI|AN|CI|A)/";
  preg_match($r,$nom, $matches);
  if(sizeof($matches) > 0)
    {
      $s=array("classe"=>$matches[1],"mois"=>$matches[2],"annee"=>$matches[3],"centre"=>$matches[4]);
    }
  else
    {
      $s=array("classe"=>"undef","mois"=>"undef","annee"=>"undef","centre"=>"undef");
    }
  return $s;
}

function tableau_selection($requete,$cle,$valeur,$connexion,$mode_assistant=0)
{
    $resultat=ExecRequete ($requete,$connexion);
    
    while ($obj=LigneSuivante($resultat))
    {
        $liste[$obj->$cle]=$obj->$valeur;
    }
    if($mode_assistant == 0)
      {
	$liste[0]="";
      }
    return $liste;
}

function id_cor_to_nom($id,$connexion)

{

  $r="SELECT nom FROM BAC WHERE BAC.ref_id_exo='$id'";
  $resultat=ExecRequete($r,$connexion);
  while($tmp=LigneSuivante($resultat))
    {
      return $tmp->nom;
    }


}

function id_to_nom($id,$connexion)

{

  $r="SELECT nom FROM BAC WHERE BAC.ref_id_exo=$id";
  $resultat=ExecRequete($r,$connexion);
  while($tmp=LigneSuivante($resultat))
    {
      return $tmp->nom;
    }


}
  
?>