<?php
/*
    exos.sesamath.net
    Copyright 2006 sesamath
    Contact : vincent.ledda@sesamath.net
    
    This file is part of exos.sesamath.net.

    exos.sesamath.net is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    exos.sesamath.net is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with exos.sesamath.net; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
define ("DEBUG","1");
define ("LEVEL","3");
define ("PAGE","3");


require_once ('xajax/xajax.inc.php');

session_start(); 
$session_id=session_id();
require 'constantes2.php';
require 'db_lib.php';
$connexion = Connexion (NOM,PASS,BASE,SERVEUR);
/*
###########################################################################
################# AJAX #############################################################
*/
class myXajaxResponse extends xajaxResponse
{  
    function addCreateOption($sSelectId, $sOptionText, $sOptionValue)  
    {  
        $this->addScript("addOption('".$sSelectId."', '".$sOptionText."', '".$sOptionValue."');");
    }

    function addCreateOptions($sSelectId, $aOptions)
    {
        foreach($aOptions as $sOptionText => $sOptionValue)
        {
            $this->addCreateOption($sSelectId, $sOptionText, $sOptionValue);
        }
    }
}

function themes($niveau,$theme)
{
  global $connexion;
  if($niveau != 0)
    {
      if($theme !=0)
	{
	  $r="SELECT DISTINCT chapitre,id_chapitre from ChapCompNiveau,chapitre WHERE ref_id_niveau='$niveau' AND chapitre.ref_id_theme='$theme' AND ref_id_chap=id_chapitre";
	}
      else
	{
	  $r="SELECT DISTINCT chapitre,id_chapitre from ChapCompNiveau,chapitre WHERE ref_id_niveau='$niveau'  AND ref_id_chap=id_chapitre";
	}
}
  else
    {
      $r="SELECT DISTINCT chapitre,id_chapitre from chapitre WHERE  chapitre.ref_id_theme='$theme'";
    }
  $resultat=ExecRequete($r,$connexion);
  $objResponse = new myXajaxResponse();
  $aOptions=array(""=>0);
  while($tmp=LigneSuivante($resultat))
    {
      $aOptions[$tmp->chapitre]=$tmp->id_chapitre;
    }
  //  $objResponse->addScript("removeMe(chapitre)");
  $objResponse->addCreateOptions("chapitre", $aOptions);
 
  return $objResponse->getXML();
}

$xajax = new xajax();
$xajax->registerFunction('themes');
$xajax->processRequests(); 


############################################
############# Fin d'Ajax ####################
##################################



############################
## inclusion librairie
##################################

//A enlever si elle ne sertque pour débogger
require 'outils_lib.php';
$debugs=array();


require 'Smarty.class.php';
require 'auth_lib.php';
require 'sesabac_lib.php';
require 'controle_lib.php';


$smarty = new Smarty;
$smarty->caching = false;
$smarty->assign('xajax_javascript', $xajax->getJavascript());


### Le panier ###
include 'pannier.php';
$panier = new pannier();

/*
###################################################################################################
         Récupération des variables POST et GET
###################################################################################################
*/






$debugs[]=debug($_POST,"post",3);
$debugs[]=debug($_GET,"get",2);
$debugs[]=debug($_SESSION,"session",3);


/*
###################################################################################################
***********       Début du traitement  ************************************************************
###################################################################################################
*/



if($_GET["init"] == "oui")
  {
unset($_SESSION["r"]);
}
if(isset($_SESSION["offset"]) AND $_GET["suivant"] == "oui")
{
$_SESSION["offset"]=$_SESSION["offset"]+1;
}
if(isset($_SESSION["offset"]) AND $_GET["precedent"] == "oui")
{
$_SESSION["offset"]=$_SESSION["offset"]-1;
}


/*
############################################################
### Le panier ##############################
###############################################################################
*/

//le tableau exo ou cor est renseigné: on remplit le panier
if(is_array($_SESSION["panier"]))
  {
    $panier->restore($_SESSION["panier"]);
    $debugs[]=debug($panier->afficher(),'pannier',2);
   
  }
    if(isset($_POST['exo']) or isset($_POST['cor']))
  {
    if(sizeof($_POST['exo']) >0)
      {
	foreach($_POST['exo'] as $exo)
	  {
	    $panier->entreexo($exo);
	  }
      }
    
    if(sizeof($_POST['cor']) >0)
      {
	foreach($_POST['cor'] as $cor)
	  {
	    $panier->entrecor($cor);
	  }
      }
    $debugs[]=debug($panier->afficher(),'pannier',2);
    $_SESSION["panier"]=$panier->save();

  }

$smarty->assign('panier',$panier->smartiser($connexion));
$debugs[]=debug($panier->smartiser($connexion),'smartiser',2);

//choix de la série menu gauche
if($_POST['choixserie'] != "")
  {
    $serie=$_POST['choixserie'];
    $_SESSION["id_serie"]=$serie;
    $_SESSION["serie"]=nomserie($serie,$connexion);
    unset($_SESSION["annee"]);
    unset($_SESSION["centre"]);
    $smarty->assign('serie',$_SESSION["serie"]);
    $smarty->display('serie.tpl');
    exit();
  }



//  chercher est renseigné: on cherche

if($_POST["chercher"] != "")
  {
    $query=cleanR($_POST['plaintext']);
    //$query='"'.$query.'"';
    $debugs[]=debug($query,"querry",3);
    $udm_agent =Udm_Alloc_Agent('mysql://mnogosearch:mngoSesabac@localhost/mnogosearch/?dbmode=multi');
    Udm_Set_Agent_Param($udm_agent,UDM_PARAM_CHARSET ,"utf-8");
    //Udm_Set_Agent_Param($udm_agent,UDM_PARAM_BROWSER_CHARSET,"utf-8");
    Udm_Set_Agent_Param($udm_agent,UDM_PARAM_HLBEG,"<strong>");
    Udm_Set_Agent_Param($udm_agent,UDM_PARAM_HLEND,"</strong>");
    
    
    $resultats=Udm_Find($udm_agent, $query);
    $totalMatches = udm_get_res_param ($resultats,UDM_PARAM_FOUND);
    $urls=array();
    if($totalMatches != 0)
      {
	$_SESSION['resultats']=array();
	for($i=0; $i<min($totalMatches,10);$i++)
	  {
	    $debugs[]=debug(udm_get_res_field($resultats,$i, UDM_FIELD_URL),'resultat!!',3);
	    if (HOTE == 'lalabel')
	      {
		$urlpdf=udm_get_res_field($resultats,$i, UDM_FIELD_URL);
		$titre=str_replace("http://lalabel/~vincent/Sesabac/sujets/","",udm_get_res_field($resultats,$i, UDM_FIELD_URL));
	      }
	    else
	      {
		$urlpdf=str_replace("localhost","exos.sesamath.net",udm_get_res_field($resultats,$i, UDM_FIELD_URL));
		$titre=str_replace("http://localhost/Sesabac/sujets/","",udm_get_res_field($resultats,$i, UDM_FIELD_URL));

	      }
	    $debugs[]=debug($titre,'resultat!titre!',3);
	    $debugs[]=debug($urlpdf,'resultat!pdf!',3);
	    $text=utf8_encode(str_replace("","</strong>",str_replace("","<strong>",udm_get_res_field($resultats,$i, UDM_FIELD_TEXT))));
	    $id=rand();
	    $resultat=nom_to_info($titre);
	    $url="index.php?resultat=$id";
	    $_SESSION['resultats'][$id]=$resultat;
#            $text=udm_get_res_field($resultats,$i, UDM_FIELD_TEXT);
	    $info=udm_get_res_param ($resultats,UDM_PARAM_WORDINFO);
	    $urls[] = array("classe"=>$resultat['classe'],"annee"=>$resultat['annee'],"centre"=>$resultat['centre'],"mois"=>$resultat['mois'],"urlpdf"=>$urlpdf,"url"=>$url,"text"=>$text,"titre"=>$titre,"info"=>$info);
	  }
	$smarty->assign('urls',$urls);
      }
}

if($_POST["chercherchapitre"] != "")
  {
    $nbpage= (int) PAGE;
    //création des sélections en SQL
    $serie=$_POST["niv_sel"];

    if($serie == 0)
      {
	$req_serie="";
      }
    else
      {
	$req_serie=" AND BAC.ref_id_serie='$serie'";
      }

   
    $theme=$_POST["theme_sel"];
    $chapitre=$_POST["chapitre_sel"];

    if($chapitre != 0)
      {
	$req_chapitre=" AND ref_id_chap='$chapitre'";
    $r="FROM BAC,exercice,ChapCompNiveau,CompExo WHERE "
      ." ChapCompNiveau.ref_id_comp=CompExo.ref_id_comp"
      ." AND CompExo.ref_id_exo=BAC.ref_id_exo".$req_chapitre.$req_serie ;
      }
    else
      {
	if($theme == 0)
	  {
	    $r=" FROM BAC WHERE ref_id_serie='$serie'";
	  }
	else
	  {
	    $req_theme=" AND ref_id_theme='$theme'";
	    $r="FROM BAC,exercice,ChapCompNiveau,chapitre,CompExo WHERE "
	  ." ChapCompNiveau.ref_id_comp=CompExo.ref_id_comp"
	  ." AND ChapCompNiveau.ref_id_chap=chapitre.id_chapitre"
	  ." AND CompExo.ref_id_exo=BAC.ref_id_exo".$req_serie.$req_theme;
	 
	  }
      }
    
    $debugs[]=debug($r,"re",3);

    

    //calcul du nombre de résultat et mise en place de l'index etc...

    
    $resultat=ExecRequete("SELECT  count(DISTINCT id_bac) as nombre ".$r,$connexion);
    $tmp=LigneSuivante($resultat);
    //le nombre d'exercice
    $count=$tmp->nombre;
    //on découpe en 5 donc il y aura $fin +1   pages
    $fin=floor(($count-1)/$nbpage);
    
    // on commence à la page d'index 0
    $offset=0;
    // On enregistre dans des variables de sessions
    $_SESSION['r']=$r;
    $_SESSION['fin']=$fin;
    $_SESSION['offset']=$offset;
    $_SESSION['count']=$count;
    //

  }
if(isset($_SESSION['r']))
  {
    $nbpage= (int) PAGE;
    $r=$_SESSION['r'];
    $fin=$_SESSION['fin'];
    $Offset=$nbpage*$_SESSION['offset'];
    $r1="SELECT DISTINCT BAC.ref_id_exo,annee,mois,ref_id_centre,ref_id_serie,specialite,numero,cor ";
    $r2=" ORDER BY annee DESC LIMIT $Offset, $nbpage";

     









    //affichage des résultats
    $resultat=ExecRequete($r1.$r.$r2,$connexion);

    $sujets=array();
     
    while($tmp=LigneSuivante($resultat))
     
      {
	$sujet["annee"]=$tmp->annee;
	$sujet['serie']=nomserie($tmp->ref_id_serie,$connexion);
	$sujet['id_centre']=$tmp->ref_id_centre;
	$sujet['centre']=centre($tmp->ref_id_centre,$connexion);
	$sujet['mois']=mois($tmp->mois);
	$sujet['id_mois']=$tmp->mois;
	$sujet["id"]=$tmp->ref_id_exo;

	$sujet["cor"]=$tmp->cor;
	if($tmp->cor == "00000")
	  {
	    $sujet["cor_disabled"]="disabled=\"disabled\"";
	  }
	else
	  {
	    $sujet["cor_disabled"]="";
	  }
	$addon="";
	if($tmp->specialite == 1)
	  {
	    $addon=" (spé)";
	  }
	$sujet["numero"]=$tmp->numero.$addon;
	
       	$sujets[]=$sujet;
	unset($sujet);
      }

    $smarty->assign('sujets',$sujets);
    $debugs[]=debug($sujets,"sujets",2);
    $smarty->assign('resultats',$_SESSION['count']);
    $smarty->assign('debugs',$debugs);
    $smarty->assign('offset',$_SESSION['offset']+1);
    $smarty->assign('fin',$fin+1);

    $smarty->display('resultats.tpl');
    exit();
  }


//page de départ
//les séries
$r="SELECT DISTINCT id_niveau,serie FROM niveau,BAC WHERE ref_id_serie=id_niveau";
$resultat=ExecRequete($r,$connexion);
$niveaux=array(0=>"");
while($tmp=LigneSuivante($resultat))
    {
      $niveaux[$tmp->id_niveau]=$tmp->serie;
      }
$smarty->assign('niveaux',$niveaux);
$smarty->assign('niveau_S',0);

//les thèmes
$smarty->assign('themes',tableau_selection("select * from theme","id_theme","theme",$connexion));
$smarty->assign('theme_S',0);
//Les chapitres
$smarty->assign('chapitres',tableau_selection("select * from chapitre","id_chapitre","chapitre",$connexion));
$smarty->assign('chapitre_S',0);


$smarty->assign('debugs',$debugs);
$smarty->display('recherche.tpl');

?>
