
<?php
/*
    exos.sesamath.net
    Copyright 2006 sesamath
    Contact : vincent.ledda@sesamath.net
    
    This file is part of exos.sesamath.net.

    exos.sesamath.net is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    exos.sesamath.net is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with exos.sesamath.net; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

session_start(); 

//define ("DEBUG","1");
define ("LEVEL","3");


//A enlever si elle ne sertque pour débogger
require 'outils_lib.php';
$debugs=array();

require 'constantes2.php';
require 'Smarty.class.php';
require 'db_lib.php';
require 'auth_lib.php';
require 'sesabac_lib.php';
require 'controle_lib.php';

$connexion = Connexion (NOM,PASS,BASE,SERVEUR);
$smarty = new Smarty;
$smarty->caching = false;


include 'pannier.php';
$panier = new pannier();

/*
###################################################################################################
         Récupération des variables POST et GET
###################################################################################################
*/
//contrôle des résultats de recherche
if($_GET['resultat'] != "" AND is_array($_SESSION['resultats']))
  {
    
    if (array_key_exists($_GET['resultat'],$_SESSION['resultats']))
      {
	$resultat=$_SESSION["resultats"][$_GET["resultat"]];
	$_SESSION["annee"]=$resultat["annee"];
	$_SESSION["mois"]=idmois($resultat["mois"]);
	$_SESSION["centre"]=idcentre($resultat["centre"],$connexion);
	$_SESSION["serie"]=$resultat["classe"];
	$_SESSION["serieid"]=idserie($resultat["classe"],$connexion);
      }
    unset($_SESSION["resultats"]);
    
}
	  


//contrôle de la variable annee
if($_GET["annee"] != "")
  {
    unset($_SESSION["annee"]);
    if(controle_annee($_GET["annee"]))
      {
	$_SESSION["annee"]=$_GET["annee"];
	unset($_SESSION["centre"]);
	unset($_SESSION["mois"]);
	$debugs[]=debug($_SESSION["annee"],"annee",1);
      }
  }

//contrôle de la variable centre
if($_GET["centre"] != "")
  {
  unset($_SESSION["centre"]);
  if(controle_centre($_GET["centre"]))
  {
    $_SESSION["centre"]=$_GET["centre"];
    $debugs[]=debug($_SESSION["centre"],"centre",1);
  }
}

//contrôle de la variable mois
if($_GET["mois"] != "")
  {
    unset($_SESSION["mois"]);
    if(controle_mois($_GET["mois"]))
      {
	$_SESSION["mois"]=$_GET["mois"];
	$debugs[]=debug($_SESSION["mois"],"mois",1);
      }
  }

if($_GET["retour"] == "oui")
  {
    unset($_SESSION["centre"]);
    unset($_SESSION["mois"]);
  }
  
if($_GET["acceuil"] == "oui")
  {
    unset($_SESSION["centre"]);
    unset($_SESSION["mois"]);
    unset($_SESSION["annee"]);
    unset($_SESSION["serieid"]);
    unset($_SESSION["serie"]);
  
  }
  

$debugs[]=debug($_POST,"post",3);
$debugs[]=debug($_GET,"get",3);
$debugs[]=debug($_SESSION,"session",3);


/*
###################################################################################################
***********       Début du traitement  ************************************************************
###################################################################################################
*/

//le tableau exo ou cor est renseigné: on remplit le panier
if(is_array($_SESSION["panier"]))
  {
    $panier->restore($_SESSION["panier"]);
    $debugs[]=debug($panier->afficher(),'pannier',2);
   
  }
    
if(isset($_POST['exo']) or isset($_POST['cor']))
  {
    if(sizeof($_POST['exo']) >0)
      {
	foreach($_POST['exo'] as $exo)
	  {
	    $panier->entreexo($exo);
	  }
      }
    
    if(sizeof($_POST['cor']) >0)
      {
	foreach($_POST['cor'] as $cor)
	  {
	    $panier->entrecor($cor);
	  }
      }
    $debugs[]=debug($panier->afficher(),'pannier',2);
    $_SESSION["panier"]=$panier->save();

  }
$smarty->assign('panier',$panier->smartiser($connexion));
$debugs[]=debug($panier->smartiser($connexion),'smartiser',2);

//choix de la série menu gauche
if($_POST['choixserie'] != "" AND $_POST['choixserie'] != 0)
  {
    $debugs[]=debug($_POST['choixserie'],"choix",3);
    $debugs[]=debug($_POST['choixserie'] != 0,"choix",3);
    
    $serie=$_POST['choixserie'];
    
    $_SESSION["serie"]=nomserie($serie,$connexion);
    $_SESSION["serieid"]=$serie;
    
    unset($_SESSION["annee"]);
    unset($_SESSION["centre"]);
    $smarty->assign('serie',$_SESSION["serie"]);

    $debugs[]=debug($_SESSION["serieid"],"choix",3);

    $smarty->assign('debugs',$debugs);
 
    $smarty->display('serie.tpl');
    exit();
  }



// centre est renseignée: la page série/année/centre


if(isset($_SESSION["centre"]) and isset($_SESSION["mois"]) )
  {
    $annee=$_SESSION["annee"];
    $serie=$_SESSION["serie"];
    $serieid=$_SESSION["serieid"];
    $centre=$_SESSION["centre"];
    $mois=$_SESSION["mois"];
    
    $smarty->assign('annee',$annee);
    $smarty->assign('serie',$serie);
    $smarty->assign('id_centre',$centre);
    $smarty->assign('centre',centre($centre,$connexion));
    $smarty->assign('mois',mois($mois));
    $smarty->assign('id_mois',$mois);
    
    $sujets=array();
    $r="SELECT DISTINCT * FROM BAC WHERE ref_id_centre='$centre' AND annee='$annee' AND ref_id_serie='$serieid' AND mois='$mois' ORDER BY numero";
    $debugs[]=debug($r,"requete",3);
    $resultat=ExecRequete($r,$connexion);
  
    while($tmp=LigneSuivante($resultat))
      {
	
	$sujet["id"]=$tmp->ref_id_exo;

	$sujet["cor"]=$tmp->cor;
	if($tmp->cor == "00000")
	  {
	    $sujet["cor_disabled"]="disabled";
	  }
	else
	  {
	    $sujet["cor_disabled"]="";
	  }
	$addon="";
	if($tmp->specialite == 1)
	  {
	    $addon=" (spé)";
	  }
	$sujet["numero"]=$tmp->numero.$addon;
	
       	$sujets[]=$sujet;
	unset($sujet);
      }


    $smarty->assign('sujets',$sujets);
    $debugs[]=debug($sujets,"sujets",3);

    $smarty->assign('debugs',$debugs);
 
    $smarty->display('sujet.tpl');
    exit();


  }
// annee est renseignée: la page série/année
if(isset($_SESSION["annee"]))
  {
    $annee=$_SESSION["annee"];
    $serie=$_SESSION["serie"];
    $smarty->assign('annee',$annee);
    $smarty->assign('serie',$serie);
    $centres=array();
    $r="SELECT DISTINCT id_centre,centre,centre_abr,mois FROM centre,BAC,niveau WHERE id_centre=ref_id_centre AND annee='$annee' AND serie='$serie' AND ref_id_serie=id_niveau";
    $resultat=ExecRequete($r,$connexion);

    while($tmp=LigneSuivante($resultat))
      {

	$centre["id"]=$tmp->id_centre;
	$centre["nom"]=$tmp->centre;
	$centre["mois"]=mois($tmp->mois);
	$centre["id_mois"]=$tmp->mois;
	$centre["abr"]=$tmp->centre_abr;
	$centre["nom_fichier"]=$serie.ucfirst($centre["mois"]).$annee.$centre["abr"];
	
	$nom_fichier=$centre["nom_fichier"];
	$nb_exo=intval(nb_exo($centre["id"],$tmp->mois,$annee,$serie,$connexion));
	
	$debugs[]=debug($nom_fichier,"nom fichier",3);
	$debugs[]=debug("sujets/corrections/".$nom_fichier.'_corr.pdf',"correction pdf",3);
	$debugs[]=debug($nb_exo,"nombre",3);

	$centre["pdf"]=lien("sujets/".$nom_fichier.'.pdf');
	$centre["tex"]=lien("sujets/".$nom_fichier.'.tex',"application/application/x-latex");
	$centre["swf"]=lien_swf($nom_fichier,pourcentage_swf($nb_exo,$nom_fichier,$connexion));
	$centre["cor"]=lien("sujets/corrections/".$nom_fichier.'_corr.pdf');
	$centres[]=$centre;
	unset($centre);
      }
    $smarty->assign('centres',$centres);
    $debugs[]=debug($centres,"centres",3);

    $smarty->assign('debugs',$debugs);
 
    $smarty->display('annee.tpl');
    exit();


  }

$smarty->assign('debugs',$debugs);
$smarty->display('index.tpl');

?>
