<?php
/*
    exos.sesamath.net
    Copyright 2006 sesamath
    Contact : vincent.ledda@sesamath.net

    This file is part of exos.sesamath.net.

    exos.sesamath.net is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    exos.sesamath.net is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with exos.sesamath.net; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
define ("DEBUG","1");
define ("LEVEL","3");



require_once ('xajax/xajax.inc.php');

session_start(); 
$session_id=session_id();
require 'constantes.php';
require 'db_lib.php';
$connexion = Connexion (NOM,PASS,BASE,SERVEUR);
######################
## xAjax
#########################

if (!$_SESSION['rowCounter'])
  {
    $_SESSION['rowCounter'] = 0;
  }

function addImage($id,$path,$ref)
{
    $_SESSION['rowCounter']++;
    $objResponse = new xajaxResponse();
    #première ligne tableau image
    $objResponse->addCreate('tableBody','tr','row' . $_SESSION['rowCounter']);
    $objResponse->addCreate('row' . $_SESSION['rowCounter'], 'td', 'cell' . $_SESSION['rowCounter']);
    $objResponse->addAssign('cell' .$_SESSION['rowCounter'],'colspan','2');
    $objResponse->addAssign('cell' .$_SESSION['rowCounter'], 'innerHTML','<a href="graphiques/'.$path.'.png" target="_blank" ><img src="graphiques/s'.$path.'.png" class="img" alt="un graphique"  /></a><img src="images/fileclose.png" alt="supprimer l\'image " onClick="xajax_removeImage('.$id.','. $_SESSION['rowCounter'].')"/>');
   

    #première ligne formulaire
    $objResponse->addCreateInput('formulaire','hidden',"image_ref[]",'image' . $_SESSION['rowCounter']);
    $objResponse->addAssign('image' . $_SESSION['rowCounter'],"value",$ref);
    
    $_SESSION['rowCounter']++;
    #seconde ligne tableau image
    #première colonne
    $objResponse->addCreate('tableBody','tr','row' . $_SESSION['rowCounter']);
    $objResponse->addCreate('row' . $_SESSION['rowCounter'], 'td', 'cell' . $_SESSION['rowCounter']);
    
    #seconde ligne formulaire
    $objResponse->addCreateInput('formulaire','hidden',"image_id[]",'image' . $_SESSION['rowCounter']);
    $objResponse->addAssign('image' . $_SESSION['rowCounter'],"value",$id);
    $objResponse->addAssign('cell' .$_SESSION['rowCounter'], 'innerHTML',$ref);
    
    
    
    return $objResponse->getXML();
}

function removeImage($id,$row)
{
  global $connexion;
  $resultat=ExecRequete("DELETE FROM images WHERE id_image='$id'",$connexion);
  
  $objResponse = new xajaxResponse();
  $objResponse->addRemove('row' .$row);
  $objResponse->addRemove('image' .$row);
  $row++;
  $objResponse->addRemove('row' .$row);
  $objResponse->addRemove('image' .$row);
  return $objResponse->getXML();
}
  
  
    

$xajax = new xajax();
$xajax->registerFunction('addImage');
$xajax->registerFunction('removeImage');
$xajax->processRequests(); 


############################
## inclusion librairie
##################################

//A enlever si elle ne sertque pour débogger
require 'outils_lib.php';
$debugs=array();



require 'Smarty.class.php';

require 'auth_lib.php';
require 'images_lib.php';
require 'sesabac_lib.php';
require 'controle_lib.php';

$smarty = new Smarty;
$smarty->caching = false;
$smarty->assign('xajax_javascript', $xajax->getJavascript());

######################
## Authentification
######################


if(isset($_POST['login']) and $_POST['login'] == 'entrer')
  {
    login(MyAddSlashes($_POST['email']),MyAddSlashes($_POST['mdp']),$connexion);
  }

if(!has_session($session_id,$connexion))
{
  $smarty->assign('retour',"correction.php");
  $smarty->display('authentification.tpl');
  exit();
}



$debugs[]=debug(has_session($session_id,$connexion),"Session id",1);
$debugs[]=debug($_SESSION,"Session",2);
$debugs[]=debug($_GET,"Get",2);
$debugs[]=debug($_POST,"Post",2);
$auteur=ses2user_id($session_id,$connexion);
list($prenom,$nom)=ses2noms(session_id(),$connexion);
$debugs[]=debug(array("auteur"=>$auteur,"prenom"=>$prenom,"nom"=>$nom),"auteur",1);









##################################
## Analyse des arguments
##################################

if($_GET["retour"] == "oui")
  {
    unset($_SESSION['exos']);
  }
  
//choix de la série menu gauche
if($_POST['choixserie'] != "" and controle_serie($_POST['choixserie'],$connexion))
  {
//Ã  tester
    $serie=$_POST['choixserie'];
    $_SESSION["id_serie"]=$serie;
    $_SESSION["serie"]=nomserie($serie,$connexion);
    $smarty->assign('serie',$_SESSION["serie"]);

  }
else
{
	unset($_SESSION["id_serie"]);
	unset($_SESSION["serie"]);
}
$debugs[]=debug(controle_exo($_GET['exo'],$connexion),"n°exo",2);
if(isset($_GET['exo']) and $_GET['exo'] != "" and controle_exo($_GET['exo'],$connexion))
{
  //exo à tester

  $_SESSION['exo']=$_GET['exo'];
}


if(isset($_POST['correction']) and $_POST['correction'] != "" )
  {
    $_SESSION['correction']=MyAddSlashes($_POST['correction']);
  }

#######################################
## Sujets par série
#############################


if($_SESSION['id_serie'] != "" and  !isset($_SESSION['exo']))
  {
    $debugs[]=debug(!isset($_SESSION['exo']),"exoe",1);
    $serie=$_SESSION["serie"];
   $id_serie=$_SESSION["id_serie"];
   $donnees=array();


	$sujets=array();
	$debugs[]=debug("SELECT DISTINCT annee, ref_id_centre as centre,mois FROM BAC WHERE ref_id_serie='$id_serie' ORDER by annee","r",1);
	$resultat1=ExecRequete("SELECT DISTINCT annee, ref_id_centre as centre,mois FROM BAC WHERE ref_id_serie='$id_serie' ORDER by annee",$connexion);
	while($tmp1=LigneSuivante($resultat1))
	{
		$nom=centre($tmp1->centre,$connexion)." ".mois($tmp1->mois)." $tmp1->annee";
		$exercices=array();
		$resultat2=ExecRequete("SELECT numero,ref_id_exo,cor,specialite FROM BAC WHERE annee='".$tmp1->annee."' AND mois='".$tmp1->mois."' AND  ref_id_centre='".$tmp1->centre."' AND ref_id_serie='".$id_serie."'",$connexion);
		while($tmp2=LigneSuivante($resultat2))
		{
			$exercice=array();
			if($tmp2->cor == "00000")
			{
				$tmp3='<img src="images/non.png">';	
			}
			else
			{
				$tmp3='<img src="images/oui.png">';
			}
			
			$exercice["numero"]=$tmp2->numero;
			$exercice["sujet"]=$tmp2->ref_id_exo;
			$exercice["cor"]=$tmp3;
			if($tmp2->specialite == 0)
				$exercice["spe"]="";
			else
				$exercice["spe"]="(spécialité)";
			
			$exercices[]=$exercice;	
		}
	
	$sujets[$nom]=$exercices;	
	}


$donnees[$serie]=$sujets;

$debugs[]=debug($donnees,"data",1);
$debugs[]=debug($_SESSION,"Session",1);
$smarty->assign('debugs',$debugs);
$smarty->assign('donnees',$donnees);
$smarty->display("correction.tpl");
exit();
  }



##################################
##### Correction envoyée
#################################
if($_POST['suite'] == 'Envoyer' AND isset($_SESSION['exo_S']) AND $_SESSION['correction'] != "")
{  
     $cor=ereg_replace("\r\n","\n",$_SESSION['correction']);
    $exo=$_SESSION['exo_S'];
    $r="SELECT cor FROM BAC WHERE ref_id_exo='$exo'";
    $resultat=ExecRequete($r,$connexion);
    $tmp=LigneSuivante($resultat);
    if($tmp->cor == '00000')
    {

      //C'est une nouvelle correction
      $r1="INSERT into correction (correction,ref_id_exo,ref_id_auteur) VALUES ('$cor','$exo','$auteur')";
      if(!ExecRequete($r1,$connexion))
	 {
	   echo "erreur";
	   exit();
	 }
      $id_cor=DerniereCle();
      $debugs[]=debug($id_cor,"last_key",2);
      $r2="UPDATE BAC set cor='1' WHERE ref_id_exo='$exo'";
      if(!ExecRequete($r2,$connexion))
	{
	  echo "r2";
	  exit();
	}
      $debugs[]=debug($_POST['image_ref'],"ref0",3);
      $debugs[]=debug($_POST['image_id'],"id0",3);
      $debugs[]=debug($cor,"cor0",3);
 
      if(is_array($_POST['image_ref']) AND count($_POST['image_ref'])>0)
	{
	  $cor=Enregistrer_corfig($id_cor,$_POST['image_ref'],$_POST['image_id'],$cor,$connexion);
	}

      image("cor_".$exo,MyStripSlashes($cor),0);
    }
    else
      {

	//mise à jour d'une correction
	 
	 $resultat4=ExecRequete("SELECT id_correction FROM correction  WHERE ref_id_exo='$exo'",$connexion);
	 
	 $tmp4=LigneSuivante($resultat4);
	 $id_cor=$tmp4->id_correction;
	 $cor=ereg_replace("\r\n","\n",$cor);
	 $debugs[]=debug($id_cor,"last_key",2);
	 $debugs[]=debug($_POST['image_ref'],"ref",3);
	 $debugs[]=debug($_POST['image_id'],"id",3);
	 $debugs[]=debug($cor,"cor",3);
	

	 if(is_array($_POST['image_ref']) AND count($_POST['image_ref'])>0)
	   {
	     
	     $cor=Enregistrer_corfig($id_cor,$_POST['image_ref'],$_POST['image_id'],$cor,$connexion);
	     
	   }

	 image("cor_".$exo,MyStripSlashes($cor),1);
	 $r3="UPDATE correction set correction='$cor' WHERE ref_id_exo='$exo'";
	 if(!ExecRequete($r3,$connexion))
	   {
	     echo "r3";
	     break;
	   }
      }
    $_SESSION['exo']=$exo;
    unset($_SESSION['correction']);
    $messages=array();
    $messages[]=$message;
    $smarty->assign('messages',$messages);
  }


###########################
#### Exercice sélectionné
##############################

if(isset($_SESSION['exo']))
{
  $exo=$_SESSION['exo'];
  $r="SELECT * FROM BAC,niveau,centre WHERE ref_id_exo='$exo' AND ref_id_centre=id_centre AND ref_id_serie=id_niveau";
  $resultat=ExecRequete($r,$connexion);
  $tmp=LigneSuivante($resultat);
  $smarty->assign('centre',$tmp->centre);
  $smarty->assign('serie',$tmp->serie);
  $smarty->assign('numero',$tmp->numero);
  $smarty->assign('specialite',$tmp->spe);
  $smarty->assign('mois',mois($tmp->mois));
  $smarty->assign('annee',$tmp->annee);
  $smarty->assign('exercice',$exo);
  if($tmp->cor != '00000')
    {
      $r1="SELECT * FROM correction,auteur WHERE ref_id_exo='$exo' AND ref_id_auteur=id_auteur";
      $resultat1=ExecRequete($r1,$connexion);
      $debugs[]=debug($r1,"requete correction",3);
      $tmp1=LigneSuivante($resultat1);
      $smarty->assign('auteur_nom',$tmp1->nom_auteur);
      $smarty->assign('auteur_prenom',$tmp1->prenom_auteur);
      $smarty->assign('auteur_email',$tmp1->email_auteur);
      $smarty->assign('correction_in',$tmp1->correction);
      $r2 = "SELECT  id_image,nom_image,format_image FROM images WHERE ref_id_cor='".$tmp1->id_correction."'";
      $debugs[]=debug($tmp->cor,'correc number',3);
      $resultat2=ExecRequete($r2,$connexion);
      $images=array();
      while($tmp2=LigneSuivante($resultat2))
	{

	  $ext=$tmp2->format_image;
	  $nom=ereg_replace('.'.$ext,'.png',$tmp2->nom_image);
	  $images[]=array("path"=>$nom, "id"=>$tmp2->id_image,"truepath"=>"../graphiques/".$tmp2->nom_image);
	}
      $smarty->assign('images',$images);
    }
  //on stocke le numéro de l'exo pour un usage futur.
  $_SESSION['exo_S']=$_SESSION['exo'];

  unset($_SESSION['exo']);
  $debugs[]=debug($_SESSION,"Session",1);
  $smarty->assign('debugs',$debugs);
  $smarty->assign('donnees',$donnees);
  $smarty->display("correction_exo.tpl");
  exit();

}


####################################
## Page par défaut
####################################

$debugs[]=debug($donnees,"data",1);
$smarty->assign('debugs',$debugs);
$smarty->assign('donnees',$donnees);
$smarty->display("correction_acceuil.tpl");

?>