/*********************************
* Module: DOM_TreeViewer.js Version 1.0
*********************************
* Using Document Object Model tree viewer:
*
* Create "Styles" subfolder and place DOM_TreeViewer.css in it
* Create "Scripts" subfolder and place DOM_TreeViewer.js in it
* If you use another folder structure you need to modify referencies in the lines
* 42 and 43
*
* Place the following code in your HTML header:
* <LINK REL="stylesheet" TYPE="text/css" HREF="Styles/DOM_TreeViewer.css">
* <SCRIPT TYPE="text/JavaScript" SRC="Scripts/DOM_TreeViewer.js"></SCRIPT>
* Place the following code in your HTML body:
* <INPUT CLASS="button" TYPE="button" VALUE="View Document Tree"
* onClick="javascript:DisplayDOM()">
*
* Open DOM Tree Viewer window by clicking on the "View Document Tree" button.
* If you wish to display only a particular branch of the DOM tree provide the ID
* of the root element to the DisplayDOM function: DisplayDOM(rootElementID)
*********************************
* Software contained in this file can be used for personal and educational purposes
* free of charge. If you are interested in utilizing this code for comercial use,
* contact the author at vladimir.g.krylov@verizon.net
*
* Copyright (c) 2002, Vlad Krylov, All Rights Reserved.
*********************************/


/* Function: DisplayDOM
* Arguments: ID - ID of the root element.
* If no argument is supplied the document root is assumed
*/

function DisplayDOM(ID)
{ 
    var winDS = window.open('','DOM_Tree','width=600,height=400,resizable=1, scrollbars=1');
    var DS=winDS.document.open('text/html','replace');
    if(ID==null)
	oRoot=document;
    else
	oRoot=document.getElementById(ID);
    DS.write('<HTML><HEAD><TITLE>DOM Node Tree: '+document.title+'</TITLE>');
    DS.write('<LINK REL="stylesheet" TYPE="text/css"');
    DS.write('HREF="inc/exos.css">');
    DS.write('<SCRIPT TYPE="text/JavaScript" ');
    DS.write(' SRC="inc/DOM_TreeViewer.js"></SCRIPT>');
    DS.write('</HEAD><BODY>');
    DS.write('<DIV CLASS=Node ID="PND_0"><NOBR>');
    DS.write('<A CLASS="ce" HREF=javascript:CollapseRestore("0")');
    DS.write(' ID="A_0">+ </A>');
    WriteNodeInfo(oRoot,DS,'0');
    DS.write('<DIV CLASS="NodeDIV" ID="0">');
    EnumChildren(oRoot,DS,'0');
    DS.write('</DIV></BODY></HTML>');
    DS.close();
}

/* Function: CollapseRestore
*/

function CollapseRestore(DIVID)
{ 
    odiv=document.getElementById(DIVID);
    odlnk=document.getElementById('A_'+DIVID);
    if(odiv.style.display=='block')
	{ 
	    odiv.style.display='none';
	    odlnk.childNodes[0].nodeValue='+ ';
	}
    else
	{ 
	    odiv.style.display='block';
	    odlnk.childNodes[0].nodeValue='- ';
	}
    return;
}



/* Function: EnumChildren
*/
function EnumChildren(oNode,DS,strTNum)
{
    var i;
    for (i=0; i<oNode.childNodes.length;i++)
	{ 
	    strNodeID=strTNum + "@" + i;
	    DS.write('<DIV CLASS=Node ID="PND_'+ strNodeID + '"><NOBR>');
	    if(oNode.childNodes[i].childNodes.length>0)
		{
		    DS.write('<A CLASS="ce" HREF=javascript:CollapseRestore("'+strNodeID+'") ID="A_'+ strNodeID + '">+ </A>');
		    WriteNodeInfo(oNode.childNodes[i],DS,strNodeID);
		    DS.write('<DIV ID="' + strNodeID +'" CLASS="NodeDIV">');
		    EnumChildren(oNode.childNodes[i],DS,strTNum + "@" + i);
		}
	    else
		{ DS.write('<SPAN CLASS="ce">&nbsp;&nbsp;</SPAN>');
		    WriteNodeInfo(oNode.childNodes[i],DS,strNodeID);
		}
	}
    DS.write('</DIV>');
    return;
}

/* Function: WriteNodeInfo
*/
function WriteNodeInfo(oWrNode,DS,strNDNum)
{ 
    var nodeText;
    if(oWrNode.nodeValue!=null)
	{
	    DS.write('<A CLASS="nd" HREF=javascript:DisplayNodeDesc("ND_'+ strNDNum + '") ID="NDA_' + strNDNum + '">');
	}
    if(oWrNode.nodeType==1)
	{ 
	    DS.write('&lt;');
	    DS.write(oWrNode.nodeName);
	    strID=oWrNode.getAttribute('ID');
	    strCLASS=oWrNode.getAttribute('CLASS');
	    if(strID!=null && strID!='' && strID!='null')
		DS.write(' ID="' + strID + '" ');
	    if(strCLASS!=null && strCLASS!='')
		DS.write(' CLASS="' + strCLASS + '" ');
	    DS.write('&gt;');
	}
    else
	{ 
	    DS.write(oWrNode.nodeName);
	}
    if(oWrNode.nodeValue!=null)
	{ 
	    DS.write('</A></NOBR>');
	    nodeText=oWrNode.nodeValue;
	    nodeText=nodeText.replace(/&/g,'&amp;');
	    nodeText=nodeText.replace(/</g,'&lt;');
	    nodeText=nodeText.replace(/>/g,'&gt;');
	    DS.write('<P CLASS="NodeDesc" ID="ND_'+ strNDNum + '">' + nodeText + '</P>');
	}
    else
	{
	    DS.write('</NOBR>');
	}
    DS.write('</DIV>');
}

/* Function: DisplayNodeDesc
*/
function DisplayNodeDesc(NDID)
{
    ond=document.getElementById(NDID);
    odiv=document.getElementById("P"+NDID);
    if(ond.style.display=='block')
	{ 
	    ond.style.display='none';
	    odiv.style.border='none';
	    odiv.style.background='none';
	}
    else
	{ 
	    ond.style.display='block';
	    odiv.style.border='solid blue 1px';
	    odiv.style.background='#E0E0FF';
}
return;
}