<?php
/*
    exos.sesamath.net
    Copyright 2004 sesamath
    Contact : vincent.ledda@sesamath.net
    
    This file is part of exos.sesamath.net.

    exos.sesamath.net is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    exos.sesamath.net is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with exos.sesamath.net; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
//Fonctions de controle de saisie des utilisateurs.

function verifie_donnee($donnee, $connexion)
//Vrifie la validit des donnes transmises lors d'une proposition d'exercice

{
  
  $FORMATS_RECONNUS=array("eps");
  $erreurs=0;
  debug($donnee["feuille"],"hello donnee auto",8);
  debug($donnee["bac"],"bac",12);
  debug(sizeof($donnee["niveau"]),"sier",12);
  if(count($donnee["feuille"]) == 0)
    {
      if(empty($donnee["competence"]))
	{
	  $erreurs=19;
	}
      elseif(empty($donnee["enonce"]))
	{
	  $erreurs=10;
	}
      elseif(empty($donnee["niveau"]))
	{
	  $erreurs=8;
	}  
      
      elseif($donnee["bac"] != 0 and  sizeof($donnee["niveau"]) > 1)
	{
	  $erreurs=15;
	}  
      /*
            elseif(empty($donnee["CDN"]))
	{
          $erreurs=8;
       }
      */
      debug($donnee["image_ref"],"ref",6);
         
      for($i=0;$i < sizeof($donnee["image_ref"]);$i++)
        {
	  if(!strstr($donnee["enonce"],$donnee["image_ref"][$i]))
            {
	      // amliorer
	      $erreurs=26;
            }
        }
      
      /*
       elseif($donnee["images"][0] != "")
         {
	 for($i=0;$i < sizeof($donnee["images"]);$i++)
            {
	      
              if($donnee["images"][$i]["nom_client"] == "" and $mode=="normal")
               {
                   debug($mode,"mode de vrification");
                   
                 $erreurs=27;
               }
              elseif(($donnee["images"][$i]["nom_serveur"] == "" or $donnee["images"][$i]["nom_serveur"] == "none" ) and $mode=="normal")
              {
                  debug($mode,"mode de vrification");
                  $erreurs=28;
               }
              elseif($donnee["images"][$i]["nom_texte"] == "" )
              {
                 $erreurs=29;
               }
              elseif($donnee["images"][$i]["nom_description"] == "" )
              {
                 $erreurs=30;
               }
             elseif(!strstr($donnee["enonce"],$donnee["images"][$i]["nom_texte"]))
              {
	         debug($donnee["images"][$i]["nom_texte"],"nom
               client");
	         debug($donnee["enonce"],"enonce");   
                 $erreurs=26;
               }
             elseif(!in_array(dernier_element(explode(".",$donnee["images"][$i]["nom_client"])),$FORMATS_RECONNUS) and $mode == "normal")
              {
                 $erreurs=25;
               }
             
            }

         }
   */
      if($erreurs == 0)
	{
	  debug($donnee["enonce"],"juste avant ctr",3);
	  $exer_md5=md5(ereg_replace("\r\n","\n",$donnee["enonce"]));
	  debug($exer_md5,"md5_new",3);
	  if(enonce_existe($exer_md5,$connexion))
	    {
	      $erreurs=4;
	    }
	}
    }
  else
    {
      debug($donnee["feuille"]['type'],"type",8);
      if($donnee["feuille"]['type'] != 'text/x-tex')
	{
	  $erreurs=14;
	  
	}
    }
  return $erreurs;
         
}



function tri_image($id,$ref)
// tri les deux tableaux suivant les valeurs dcroissantes de $ref pur viter les pb de substitution
//
{
  arsort($ref);
  reset($ref);
  $un=array();
  $deux=array();
  foreach($ref as $key=> $value)
    {
      $un[]=$value;
      $deux[]=$id[$key];
    }
  return array($deux,$un);
}








function enonce_existe($md5,$connexion)
//renvoie true si l'enonc -identifi par un hach de l'nonc- existe

{
    
    $i=false;
    $resultat = ExecRequete("SELECT control_md5 FROM exercice",$connexion);
    while ($identi = LigneSuivante($resultat))
    {
      if ($md5 == $identi->control_md5)
	{
            $i=true;
        }
        
    }
    return $i;
	 
}

function nettoyage($str)
{
  $badchars = array("select", "'","drop", ";", "--", "insert","delete", "xp_");
  foreach($badchars as $bad)
    {
      $str=str_replace($bad,"",$str);
    }
  return $str;
}


function ebac_centre($centre,$connexion)
#Renvoie l'i d'un centre d'examen $centre est l'abrviation d'un centre
{
  
  $centre=nettoyage($centre);
  $output="erreur: Le centre slectionn n'existe pas!";
  $r="SELECT id_centre FROM centre WHERE centre_abr= UCASE('$centre')";
  $resultat=ExecRequete($r,$connexion);
  while($tmp=LigneSuivante($resultat))
    {
      $output=$tmp->id_centre;
    }
  return $output;
}

function ebac_annee($annee)
{
  $output="erreur: L'anne  slectionne n'est pas valide!";
  if(in_array ($annee, array("1999","2000","2001","2002","2003","2004","2005","2006","2007")))
    {
      $output=$annee;
    }
  return $output;
}
function ebac_mois($mois)
{
  $output="erreur: Le mois  slectionn n'est pas valide!";
  $Amois=array("MAR"=>3,"JUIN"=>6,"AVR"=>4,"SEP"=>9,"NOV"=>11);
  $r=$Amois[strtoupper($mois)];
  if($r != "")
    {
      $output=$r;
    }
  return $output;
}

function ebac_serie($serie,$connexion)
{
  $serie=nettoyage($serie);
  $output="erreur: La srie slectionne n'existe pas!";
  $r="SELECT id_niveau FROM niveau WHERE serie= UCASE('$serie')";
  $resultat=ExecRequete($r,$connexion);
  while($tmp=LigneSuivante($resultat))
    {
      $output=$tmp->id_niveau;
    }
  return $output;
}
function ebac_numero($numero)
{
  $output="erreur: Le numero  slectionn n'est pas valide!";
   if(is_numeric($numero) and $numero > 0 and $numero < 10)
    {
      $output=$numero;
    }
  return $output;
}

function ebac_tout($champs,$connexion)
{
  $resultats=array();
  $resultats['serie']=ebac_serie($champs[0],$connexion);
  $resultats['centre']=ebac_centre($champs[1],$connexion);
  $resultats['mois']=ebac_mois($champs[2]);
  $resultats['annee']=ebac_annee($champs[3]);
  $resultats['numero']=ebac_numero($champs[4]);
 
  if(sizeof($champs) == 6)
    {
      
      $resultats['spe']=1;
    }
  else
    {
      $resultats['spe']=0;
    }
  debug($resultats,"resultatss",3);
  $ok=1;
  foreach($resultats as $resultat)
    {
      debug(preg_match("/erreur/",$resultat),"reg",3);
      if(preg_match("/erreur/",$resultat))
	{
	  $ok=0;
	  $output=$resultat;
	  break;
	}
    }
  if($ok)
    {

      $output="Il n'y a pas d'exercice correspondant  la demande!";
      $r="SELECT ref_id_exo FROM BAC WHERE  annee='".$resultats['annee']."' AND mois='".$resultats['mois']."' AND  ref_id_centre='".$resultats['centre']."' AND  ref_id_serie='".$resultats['serie']."' AND  specialite='".$resultats['spe']."' AND  numero='".$resultats['numero']."'";
      debug($r,"re",2);
      $resultat=ExecRequete($r,$connexion);
      while($tmp=LigneSuivante($resultat))
	{
	  $output=$tmp->ref_id_exo;
	}
    }
  return $output;
}



function ebac_existe($resultats,$connexion)
{
  $output=0;
  $r="SELECT ref_id_exo FROM BAC WHERE  annee='".$resultats['annee']."' AND mois='".$resultats['mois']."' AND  ref_id_centre='".$resultats['centre']."' AND  ref_id_serie='".$resultats['serie']."' AND  specialite='".$resultats['spe']."' AND  numero='".$resultats['numero']."'";
  debug($r,"re",9);
  $resultat=ExecRequete($r,$connexion);
  while($tmp=LigneSuivante($resultat))
    {
      $output=$tmp->ref_id_exo;
    }
  return $output;
}

function correction_existe($exo,$connexion)
{
  $output=0;
  $r="SELECT id_correction FROM correction WHERE ref_id_exo='$exo'";
   $resultat=ExecRequete($r,$connexion);
  while($tmp=LigneSuivante($resultat))
    {
      $output=$tmp->id_correction;
    }
  return $output;
  
}
?>