/*
 * Decompiled with CFR 0.152.
 */
package org.swtjar;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.eclipse.jdt.internal.jarinjarloader.RsrcURLStreamHandlerFactory;

public class SWTLoader {
    public static final String SWTJAR_MAIN_CLASS = "SwtJar-TargetMainClass";
    public static final String SWTJAR_VERSION = "SwtJar-SwtVersion";
    private static String sTargetMainClass = null;
    private static String sSwtVersion = null;

    public static void main(String[] args) throws Throwable {
        try {
            SWTLoader.loadConfig();
            ClassLoader cl = SWTLoader.getSWTClassloader();
            Thread.currentThread().setContextClassLoader(cl);
            try {
                try {
                    Class<?> c = Class.forName(sTargetMainClass, true, cl);
                    Method main = c.getMethod("main", args.getClass());
                    main.invoke((Object)null, new Object[]{args});
                }
                catch (InvocationTargetException ex) {
                    Throwable th = ex.getCause();
                    if (th instanceof UnsatisfiedLinkError) {
                        UnsatisfiedLinkError linkError = (UnsatisfiedLinkError)th;
                        String errorMessage = "(UnsatisfiedLinkError: " + linkError.getMessage() + ")";
                        String arch = SWTLoader.getArch();
                        if ("32".equals(arch)) {
                            errorMessage = errorMessage + "\nTry adding '-d64' to your command line arguments";
                        } else if ("64".equals(arch)) {
                            errorMessage = errorMessage + "\nTry adding '-d32' to your command line arguments";
                        }
                        throw new SWTLoadFailed(errorMessage);
                    }
                    if (th.getMessage() != null && th.getMessage().toLowerCase().contains("invalid thread access")) {
                        String errorMessage = "(SWTException: Invalid thread access)";
                        errorMessage = errorMessage + "\nTry adding '-XstartOnFirstThread' to your command line arguments";
                        throw new SWTLoadFailed(errorMessage);
                    }
                    throw th;
                }
            }
            catch (ClassNotFoundException ex) {
                throw new SWTLoadFailed("Failed to find main class: " + sTargetMainClass);
            }
            catch (NoSuchMethodException ex) {
                throw new SWTLoadFailed("Failed to find main method");
            }
        }
        catch (SWTLoadFailed ex) {
            String reason = ex.getMessage();
            System.err.println("Launch failed: " + reason);
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            JOptionPane.showMessageDialog(null, reason, "Launching UI Failed", 0);
        }
    }

    private static Manifest getSWTLoaderManifest() throws IOException {
        Class<SWTLoader> clazz = SWTLoader.class;
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return null;
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        return new Manifest(new URL(manifestPath).openStream());
    }

    private static void loadConfig() throws SWTLoadFailed {
        try {
            String swtVer;
            Manifest m = SWTLoader.getSWTLoaderManifest();
            if (m == null) {
                throw new SWTLoadFailed("Failed to find swtjar manifest");
            }
            Attributes mainAttributes = m.getMainAttributes();
            String mainClass = mainAttributes.getValue(SWTJAR_MAIN_CLASS);
            if (mainClass != null) {
                sTargetMainClass = mainClass;
            }
            if ((swtVer = mainAttributes.getValue(SWTJAR_VERSION)) != null) {
                sSwtVersion = swtVer;
            }
            if (sTargetMainClass == null || sSwtVersion == null) {
                throw new SWTLoadFailed("Failed to load swtjar config from manifest");
            }
        }
        catch (IOException ex) {
            throw new SWTLoadFailed("Error when loading swtjar config: " + ex.getMessage());
        }
    }

    private static String getArch() {
        String jvmArch = System.getProperty("os.arch").toLowerCase();
        String arch = jvmArch.contains("64") ? "64" : "32";
        return arch;
    }

    private static String getSwtJarName() throws SWTLoadFailed {
        String swtFileNameOsPart;
        String osName = System.getProperty("os.name").toLowerCase();
        String string = osName.contains("win") ? "win" : (osName.contains("mac") ? "osx" : (swtFileNameOsPart = osName.contains("linux") || osName.contains("nix") ? "linux" : ""));
        if ("".equals(swtFileNameOsPart)) {
            throw new SWTLoadFailed("Unknown OS name: " + osName);
        }
        String swtFileNameArchPart = SWTLoader.getArch();
        String swtFileName = "swt-" + swtFileNameOsPart + swtFileNameArchPart + "-" + sSwtVersion + ".jar";
        return swtFileName;
    }

    private static ClassLoader getSWTClassloader() throws SWTLoadFailed {
        String swtFileName = SWTLoader.getSwtJarName();
        try {
            URLClassLoader cl = (URLClassLoader)SWTLoader.class.getClassLoader();
            URL.setURLStreamHandlerFactory(new RsrcURLStreamHandlerFactory(cl));
            Method addUrlMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            addUrlMethod.setAccessible(true);
            URL swtFileUrl = new URL("rsrc:" + swtFileName);
            addUrlMethod.invoke((Object)cl, swtFileUrl);
            return cl;
        }
        catch (Exception exx) {
            throw new SWTLoadFailed(exx.getClass().getSimpleName() + ": " + exx.getMessage());
        }
    }

    private static class SWTLoadFailed
    extends Exception {
        private static final long serialVersionUID = 1L;

        private SWTLoadFailed(String xiMessage) {
            super(xiMessage);
        }
    }
}

