/*
 * Decompiled with CFR 0.152.
 */
package mastermindSolveur;

import java.util.ArrayList;
import java.util.Arrays;
import mastermindSolveur.MmOutils;

public abstract class MamSolveur {
    protected int N;
    protected int A;
    protected char[] Alphabet;
    protected String currentProposition;
    protected ArrayList<String> possibles;
    protected int[][] resultats = new int[14][2];

    public MamSolveur(int n, int a) {
        this.N = n;
        this.A = a;
        this.currentProposition = "AABB";
        this.Alphabet = MmOutils.genAlphabet(a);
        this.possibles = this.initPossible();
        int k = 0;
        int i = 0;
        while (i < 5) {
            int j = 0;
            while (j < 5 - i) {
                if (!Arrays.equals(new int[]{i, j}, new int[]{3, 1})) {
                    this.resultats[k] = new int[]{i, j};
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public ArrayList<String> getPossibles() {
        return this.possibles;
    }

    public void updateListes(int[] score) {
        ArrayList<String> possibles = new ArrayList<String>(this.possibles);
        for (String code : possibles) {
            if (Arrays.equals(MmOutils.testSolution(this.currentProposition, code), score)) continue;
            this.possibles.remove(code);
        }
    }

    public ArrayList<String> createListes(int n, ArrayList<String> liste) {
        ArrayList<String> resultat = new ArrayList<String>();
        ArrayList<String> current = liste;
        while (n > 0) {
            int i = 0;
            while (i < current.size()) {
                int j = 0;
                while (j < this.A) {
                    resultat.add(String.valueOf(current.get(i)) + String.valueOf(this.Alphabet[j]));
                    ++j;
                }
                ++i;
            }
            --n;
            current = new ArrayList(resultat);
            resultat.clear();
        }
        return current;
    }

    public ArrayList<String> initPossible() {
        String[] possible = new String[(int)Math.pow(this.A, this.N)];
        ArrayList<String> nntest = new ArrayList<String>();
        nntest.add("");
        return this.createListes(this.N, nntest);
    }

    public ArrayList<String> testProbleme(String[] questions, int[][] reponses) {
        this.possibles = this.initPossible();
        int i = 0;
        while (i < questions.length) {
            if (questions[i].length() == this.N) {
                this.currentProposition = questions[i];
                this.updateListes(reponses[i]);
            }
            ++i;
        }
        return this.possibles;
    }

    public abstract String init();

    public abstract String nextProposition();
}

