/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import mastermindSolveur.solveur;

public class Mmtotex {
    private Integer N;
    private Integer a;
    private Integer nombreExo;
    private String rep;

    public Mmtotex(int N, int a, int nombreExo, String rep) {
        this.N = N;
        this.a = a;
        this.nombreExo = nombreExo;
        this.rep = rep;
    }

    public void buildFiche() {
        int nb = 0;
        String nomFichier = String.format(String.valueOf(this.rep) + "/mastermind_%d.tex", System.currentTimeMillis() / 1000L);
        try {
            FileWriter fileWriter = new FileWriter(nomFichier, false);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            mastermind myM = new mastermind(this.N, this.a);
            char[] alphabet = myM.getAlphabet();
            StringBuilder builder = new StringBuilder();
            builder.append("\\documentclass[A4,12pt,sol]{cueep}\n%fiche g\u00e9n\u00e9r\u00e9e al\u00e9atoirement\n\t\\reference{Tests psychotechniques}\\motsclefs{Mastermind}\\titre{Mastermind}\\usepackage{array,hhline,colortbl}\n\t\t\\definecolor{lightgray}{rgb}{0.6796,0.1445,0.4492}\n\t\t\\begin{document}\nR\u00e9solvez les mastermind ci-dessous sur l'alphabet: ");
            builder.append(alphabet[0]);
            int i = 1;
            while (i < this.a) {
                builder.append(", " + alphabet[i]);
                ++i;
            }
            builder.append(".\n\n");
            while (nb < this.nombreExo) {
                solveur sol;
                ArrayList<String> solutions;
                boolean agarder = true;
                StringBuilder secret = new StringBuilder();
                int i2 = 0;
                while (i2 < this.N) {
                    secret.append(alphabet[ThreadLocalRandom.current().nextInt(this.a - 1)]);
                    ++i2;
                }
                myM.setSecret(secret.toString());
                ArrayList<Object> resolution = myM.resoudre();
                ArrayList questions = (ArrayList)resolution.get(0);
                ArrayList reponses = (ArrayList)resolution.get(1);
                int[][] Reponses = new int[reponses.size()][2];
                String[] Questions = new String[questions.size()];
                int i3 = 0;
                while (i3 < questions.size()) {
                    Questions[i3] = (String)questions.get(i3);
                    Reponses[i3] = (int[])reponses.get(i3);
                    if (Reponses[i3][0] == 3) {
                        agarder = false;
                    }
                    ++i3;
                }
                if (!agarder || (solutions = (sol = new solveur(this.N, this.a)).testProbleme(Questions, Reponses)).size() != 1) continue;
                System.out.println(String.valueOf(solutions.get(0)) + "  " + secret.toString());
                builder.append(this.mmLatexExo(Questions, Reponses, myM.getSecret()));
                ++nb;
            }
            builder.append("\\end{document}");
            bufferedWriter.write(builder.toString());
            bufferedWriter.flush();
            bufferedWriter.close();
            System.out.println("Fichier cr\u00e9\u00e9");
        }
        catch (IOException ioe) {
            System.err.println("Erreur lev\u00e9e de type IOException au niveau de la m\u00e9thode writeFile(...) : ");
            ioe.printStackTrace();
        }
    }

    public String mmLatexBloc(String[] questions, int[][] reponses) {
        int n = questions[0].length();
        StringBuilder builder = new StringBuilder();
        builder.append("\n\\begin{tabular}[h]{*");
        builder.append(n);
        builder.append("{|c}|>{$}c<{$}}\n\\cline{1-");
        builder.append(n);
        builder.append("}\n");
        int i = 0;
        while (i < questions.length) {
            int j = 0;
            while (j < n) {
                builder.append(String.valueOf(questions[i].charAt(j)) + "&");
                ++j;
            }
            builder.append(this.mmLatexRep(reponses[i]));
            builder.append(String.format("\\tabularnewline\\cline{1-%d}\n", n));
            ++i;
        }
        builder.append("\\end{tabular}");
        return builder.toString();
    }

    public String mmLatexRep(int[] reponse) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < reponse[0]) {
            builder.append("\\blacktriangle ");
            ++i;
        }
        i = 0;
        while (i < reponse[1]) {
            builder.append("\\vartriangle ");
            ++i;
        }
        return builder.toString();
    }

    public String mmLatexExo(String[] questions, int[][] reponses, String reponse) {
        StringBuilder builder = new StringBuilder();
        int n = reponse.length();
        String blocEnonce = this.mmLatexBloc(questions, reponses);
        builder.append("\\begin{exercice}\\begin{center}\n");
        builder.append(blocEnonce);
        builder.append("\\end{center}\n\\begin{sol}\n Voici la solution de ce mastermind\n\\begin{center}");
        builder.append(blocEnonce.substring(0, blocEnonce.length() - 14));
        builder.append(String.format("\\hhline{*{%s}=~}", n));
        int j = 0;
        while (j < n) {
            builder.append("\\cellcolor{lightgray}" + reponse.charAt(j) + "&");
            ++j;
        }
        builder.append(String.format("\\tabularnewline\\cline{1-%d}\n", n));
        builder.append("\\end{tabular}\n\\end{center}\n");
        builder.append("\\end{sol}\n");
        builder.append("\\end{exercice}\n");
        return builder.toString();
    }
}

