% Contact : vincent.ledda@ac-lille.fr
     

% exo.cls is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% (at your option) any later version.

% exos.cls is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with exo.cls; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{exo}[2004/29/10 v0.1 Une classe pour des exos de math]
\LoadClassWithOptions{article}

%%%%%%%%%%%%
%Dpendances
%%%%%%%%%%%%
\RequirePackage[latin1]{inputenc}
%\RequirePackage[utf8]{inputenc}
\RequirePackage[T1]{fontenc}
\RequirePackage{eurosym,vmargin,multicol,ifthen,keyval,pst-plot}
\RequirePackage{fancybox}
\RequirePackage{url,mdwlist,pifont,array,calc,epsfig,amsmath,amssymb,picins,graphicx,textcomp,color}

\RequirePackage[frenchb]{babel}

\RequirePackage{answers}
%\RequirePackage[nosolutionfiles]{answers}

%%%%%%%%%%%%%%%%%%%%%%%%
%Dimensions et compteurs
%%%%%%%%%%%%%%%%%%%%%%%%
\newdimen\largeur
\newcount\mode
\newcount\logoE
\newcount\qcmalpha
\newcount\Ent
\newcount\Nom
\newcount\style
\parindent=0mm
\newcounter{Itemm}
%% pour l'entte
\newdimen\slargeur%
\newdimen\sslargeur%
\newdimen\ltexte%
\newdimen\vsaut%
\newdimen\oldparindent%
\setlength{\vsaut}{1mm}%

\newcount\solution%
\newdimen\saut
\Ent= 0
\logoE= 0
\style =0
\solution=0
\setlength\columnsep{20mm}
\setlength\columnseprule{0.4pt}

\setlength{\largeur}{\textwidth}
\pagestyle{empty}


%%%%%%%%%%%%%%%%%
%Options et style
%%%%%%%%%%%%%%%%%

\DeclareOption{Nom}{%
\Nom= 1
}

\DeclareOption{INT}{%
 %interrogation
\Ent= 1
\newcommand{\Duree}{Dure~: 10 minutes}
\newcommand{\Date}{\today}
}

\DeclareOption{DNS}{%
\Ent= 2
%DNS
\newcommand{\Arendrele}{\`A rendre le \today}

}

\DeclareOption{BAC}{%
\Ent= 3
\newcommand{\Duree}{Dure~: 4 heures}
\newcommand{\Date}{\today}
\newcommand{\pied}{}
}
\DeclareOption{eBAC}{%
\Ent= 3
\newcommand{\Duree}{Dure~: 4 heures}
\newcommand{\Date}{\today}
\newcommand{\pied}{\centerline{\small e-BAC: \url{http://sesamath.net/e-bac/}}}

}

\DeclareOption{DS}{%
\Ent= 4
%DS
\newcommand{\Duree}{Dure~: 1 heure}
\newcommand{\Date}{\today}
}


\DeclareOption{sol}{%
\solution= 1

\Newassociation{sol}{Solution}{ans}
\renewcommand{\Solutionlabel}[1]{\bf Correction #1}


}

\DeclareOption{test}{%
\Ent= 5
\newcommand{\Duree}{Dure~: 2 heures}
\newcommand{\Date}{\today}

}

\DeclareOption{A4}{%
\setpapersize{A4}
\setmargins{10mm}{10mm}{190mm}{277mm}{0mm}{0mm}{0mm}{0mm}
\setlength\largeur{\textwidth}

\mode= 1
}

\DeclareOption{A4r}{%
\setpapersize[landscape]{A4}
\setmargins{10mm}{10mm}{277mm}{190mm}{0mm}{0mm}{0mm}{0mm}
\setlength\largeur{\textwidth}
\mode= 1

}
\DeclareOption{A4R}{%
\setpapersize[landscape]{A4}
\setmargins{10mm}{10mm}{277mm}{190mm}{0mm}{0mm}{0mm}{0mm}
\setlength\largeur{127.5mm}

\mode= 4
}
\DeclareOption{ct}{%
\setpapersize[landscape]{A4}
\setmargins{10mm}{10mm}{277mm}{190mm}{0mm}{0mm}{0mm}{0mm}
\setlength\largeur{127.5mm}

\mode= 5
}

\DeclareOption{A5}{%
\setpapersize[landscape]{A4}
\setmargins{10mm}{10mm}{277mm}{190mm}{0mm}{0mm}{0mm}{0mm}
\setlength\largeur{127.5mm}
\mode= 2
%\showthe\largeur
}

\DeclareOption{A6}{%
\setpapersize[landscape]{A4}
\setmargins{10mm}{10mm}{277mm}{190mm}{0mm}{0mm}{0mm}{0mm}
\setlength\largeur{127.5mm}
\mode= 3
%\showthe\largeur
}
\DeclareOption{A4RR}{%
\setpapersize[landscape]{A4}
\setmargins{10mm}{10mm}{277mm}{190mm}{0mm}{0mm}{0mm}{0mm}
\setlength\largeur{127.5mm}
\mode= 5
}


\DeclareOption{logo}{%
\logoE= 1
\newcommand{\Logo}{logo.eps}
\newcommand{\logo}[1]{\renewcommand{\Logo}{#1}}
}


\DeclareOption{11pt}{\fontsize{11}{12}\selectfont}
\DeclareOption{12pt}{\fontsize{12}{14.5}\selectfont}
\DeclareOption{10pt}{\fontsize{10}{13.6}\selectfont}
\DeclareOption{8pt}{\fontsize{4}{10.7}\selectfont}


\DeclareOption{ombre}{%
\style= 1
}

\DeclareOption{simple}{%
\style= 2
}

\DeclareOption{cours}{%
\pagestyle{plain}
 \ifthenelse{\mode= 4 \OR \mode
   =5}{\setmargins{10mm}{15mm}{277mm}{185mm}{0mm}{0mm}{10mm}{7mm}}

\ifthenelse{\mode= 1}{\setmargins{12mm}{15mm}{186mm}{266mm}{0mm}{0mm}{10mm}{7mm}}

}


\ExecuteOptions{A4,10pt}
\ProcessOptions\relax

%%%%%%%%%%%%%%%%%%%%%
% style
%%%%%%%%%%%%%%%%%%%%%
%\showthe\style
\ifthenelse{\style > 0}{%
  \ifthenelse{\style = 1}{%
    \input{style_ombre.tex}}{%
    \ifthenelse{\style = 2}{%
      \input{style_simple.tex}}{}}}{%
   \input{my_style.tex}}
    
  
    
  






%%%%%%%%%%%%%%%%%%
%% longueurs des colonnes d'entte
%%%%%%%%%%%%%%%%%
\setlength{\sslargeur}{\largeur * \real{0.25}}%
\setlength{\slargeur}{\largeur * \real{0.50}}%

%%%%%%%%%%%%%%%
%Commandes
%%%%%%%%%%%%%%%

\newcommand{\Classe}{Classe:$\ldots\ldots$}
\newcommand{\classe}[1]{\renewcommand{\Classe}{#1}}
\newcommand{\Num}{}
\newcommand{\num}[1]{\renewcommand{\Num}{\ \no#1}}

%%%%%%%%%%%%%%%
%Environnements
%%%%%%%%%%%%%%%


% exercices
\newcounter {Exercices}

\setcounter{Exercices}{0}
\newenvironment{exercice}[1][0]{\refstepcounter{Exercices}\noindent{\titreExercice[\theExercices]}\ifthenelse{\equal{#1}{0}}{}{\points{#1}}}{\par\vspace{1mm}}

\newenvironment{exercice*}[1][0]{\noindent{\titreExercice}\ifthenelse{\equal{#1}{0}}{}{\points{#1}}}{\par\vspace{1mm}}




% problme et parties
\newcounter {Problemes}
\newcounter {Parties}
\setcounter{Problemes}{0}
\newenvironment{probleme*}[1][0]{\refstepcounter{Problemes}\noindent{\titreProbleme}\ifthenelse{\equal{#1}{0}}{}{\points{#1}}\vspace{2mm}\\}{\par\setcounter{Parties}{0}\par\vspace{1mm}}
\newenvironment{probleme}{\refstepcounter{Problemes}\noindent\titreProbleme[\theProblemes]\vspace{2mm}\\}{\par\setcounter{Parties}{0}\par\vspace{1mm}}

\setcounter{Parties}{0}

\newenvironment{partie}[1][0]{\refstepcounter{Parties}%
{\titrePartie[\theProblemes]{\theParties}}\ifthenelse{\equal{#1}{0}}{}{\points{#1}}\par}{\par\vspace{1mm}}
\newenvironment{partie*}[1][0]{\refstepcounter{Parties}%
{\titrePartie[0]{0}}\ifthenelse{\equal{#1}{0}}{}{\points{#1}}\par}{\par\vspace{1mm}}


% remarques
\newenvironment{remarque}{\begin{center}\itshape}{\end{center}}



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Nouvelles commandes graphiques
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newlength\figh
\newlength\figw
\newlength\coeff
\def\echelle{1}
\def\format{eps}
\def\position{l}
\def\decoration{}
\def\style{\arabic}
\newsavebox{\Figureb}
\newdimen\total
\newdimen\reste
%\showthe\largeur
%\showthe\baselineskip
%\showthe\baselinestretch
\newdimen\ligneskip
\setlength\ligneskip{\baselinestretch\baselineskip}
%\showthe\ligneskip
\newenvironment{Figures}[2]{%
  \setkeys{param}{#1}\setcounter{Itemm}{1}

\setlength{\itemindent}{0pt}
\renewcommand{\item}{%
  \ifthenelse{\equal{\theItemm}{1}}{\quad\style{Itemm}.\;\;\stepcounter{Itemm}}{\hfill\break$\mbox{}${\quad\style{Itemm}.\;\;\stepcounter{Itemm}}}}
% la boite sert  trouver la hauteur 
\par\begin{lrbox}{\Figureb}
 
  \begin{minipage}[h]{\largeur}
   
    \parpic(\figw,\figh)[\position\decoration]{\parbox[b]{\figw}{\placeimage{\format}{#2}}}}{%
\renewcommand{\item}{
        \@inmatherr\item  \@ifnextchar[\@item{\@noitemargtrue
          \@item[\@itemlabel]}}
\end{minipage}
\end{lrbox}

\usebox{\Figureb}
\setlength\total{\ht\Figureb+\dp\Figureb}
\setlength\reste{\figh-\total}
%\showthe\figh
%\showthe\total
%\showthe\reste
\ifthenelse{\lengthtest{\reste >
    0pt}}{\vspace{\reste}\vspace{\ligneskip}\par}{\ifthenelse{\lengthtest{\reste>
      -5\ligneskip  }}{\vspace{\ligneskip}\par}{\par}}

}

\define@key{param}{position}{\def\position{#1}}
\define@key{param}{enumstyle}{\def\enumstyle{#1}}
\define@key{param}{decoration}{\def\decoration{#1}}
\define@key{param}{hauteur}{\setlength{\figh}{#1}}
\define@key{param}{format}{\def\format{#1}}
\define@key{param}{enumstyle}{\ifthenelse{\equal{#1}{r}}{\def\style{\roman}}{\ifthenelse{\equal{#1}{R}}{\def\style{\Roman}}{\ifthenelse{\equal{#1}{a}}{\def\style{\arabic}}{\ifthenelse{\equal{#1}{al}}{\def\style{\alph}}{\ifthenelse{\equal{#1}{Al}}{\def\style{\Alph}}{}}}}}}
\define@key{param}{largeur}{\setlength{\figw}{#1}}
\define@key{param}{echelle}[1]{\def\echelle{#1}}

%\setlength\coeff{\figw * \echelle}
%\showthe\coeff
\newcommand{\placeimage}[2]{\ifthenelse{\equal{#1}{pstex}}{\resizebox{110mm}{!}{\input{#2}}}{\ifthenelse{\equal{#1}{eps}}{\includegraphics[
      scale=\echelle, keepaspectratio=true,width=\figw,height=\figh]{#2}}{\scalebox{\echelle}{#2}}}}




%%%%%%%%%%%%%%%%%%%%%%%%
%% macro pour la saisie
%%%%%%%%%%%%%%%%%%%%%%%
\input{macro.tex}


%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% qcm
%%%%%%%%%%%%%%%%%%%%%%%
\newcommand{\QcmTexte}{Choississez parmi les rponses proposes l'unique
  bonne rponse  chaque question. Chaque rponse exacte rapporte 1 point. Une
  rponse inexacte enlve 0,25 point. Une question sans rponse ne
  rapporte ni n'enlve aucun point. Si le total est ngatif, il est
  ramen zro.
}

\newcommand{\qcmTexte}[1]{\renewcommand{\QcmTexte}{#1}}

\qcmalpha= 0
%\showthe\qcmalpha
\newcommand{\qcmAlpha}[0]{\qcmalpha=1}
\newcommand{\qcmBoite}[0]{\qcmalpha=0}

\newenvironment{Qcm}[1][2]
{
\newenvironment{qcm}[1][#1]
{
\setlength\columnsep{4mm}
\setlength\columnseprule{0pt}
  \begin{multicols}{#1}
    \ifthenelse{\qcmalpha= 0}{\begin{Pilist}{pzd}{114}}{\begin{enumerate}}}
    {\ifthenelse{\qcmalpha= 0}{\end{Pilist}}{\end{enumerate}}\end{multicols}
}
\QcmTexte


\begin{enumerate}
}{
\end{enumerate}

}



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Mise en page et format
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\wentete{\ifthenelse{\Ent > 0}{\entete}{}}
\def\wpied{\ifthenelse{\Ent > 0}{\pied}{}}
\newsavebox{\Enonce}

 \ifthenelse{\mode = 2 \OR \mode = 3}{%
   \newcommand{\Encore}{\hspace{10mm}\usebox{\Enonce}\par
     \newdimen\texte
      \newdimen\res
      \setlength{\texte}{\ht\Enonce+\dp\Enonce}
      \ifthenelse{\mode = 2}{%
        \setlength\res{532.5pt-\texte-5\lineskip}
        \ifthenelse{\res > 0 }{\vspace{\res}\wpied}}{}{%
         \setlength\res{270.30pt-\texte}
        \ifthenelse{\res > 0 }{\vspace{\res}}{}}
      
   }\newenvironment{enonce}{\begin{lrbox}{\Enonce}\begin{minipage}[b]{\largeur}\wentete}{%
     \end{minipage}\end{lrbox}\Encore\ifthenelse{\mode =2}{\Encore}{}
   \ifthenelse{\mode =3}{\Encore\Encore\Encore}{}
   }}{}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Cahier de texte
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcounter{Dns}
\setcounter{Dns}{0}
\newenvironment{dns}[1][la semaine prochaine]{\stepcounter{Dns}\begin{flushright}
    \begin{minipage}[h]{\textwidth/4}
\label{Devoir \theDns }\begin{center}Distribution du {\bf devoir non
    surveill n~\theDns\ }  rendre\ifthenelse{\equal{#1}{la semaine
    prochaine}}{}{\ le} #1.\end{center}}{
    \end{minipage}\end{flushright}}
\newcommand{\cdns}{Correction du devoir non surveill n~\theDns.}


\newcounter{Ds}
\setcounter{Ds}{0}
\newcommand{\ds}{\stepcounter{Ds}Devoir surveill n\theDs.}
\newcommand{\cds}{Correction du devoir surveill n\theDs.}

\newcounter{Inte}
\setcounter{Inte}{0}
\newcommand{\inte}{\stepcounter{Inte}Interrogation n\theInte.}
\newcommand{\cinte}{Correction de l'interrogation n\theInte.}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Dbut&fin
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\AtBeginDocument{%
  \ifthenelse{\mode = 1}{\wentete}{}%
  \ifthenelse{\solution =1}{\Opensolutionfile{ans}[ans1]}{}%


  \ifthenelse{\mode = 4}{\begin{multicols}{2}\wentete}
    
    \ifthenelse{\mode= 2 \OR \mode  =3}{\setlength{\parindent}{-10mm}\begin{multicols}{2}\begin{enonce}}{}

    \ifthenelse{\mode= 5}{\begin{multicols*}{2}\wentete}{}
}


\AtEndDocument{%
  \ifthenelse{\mode = 1}{%
    \ifthenelse{\solution =1}{%
      \Closesolutionfile{ans}\newpage\begin{center}\titrePageSolution\end{center} \Readsolutionfile{ans}}{}\vfill\wpied}


  \ifthenelse{\mode = 4}{\end{multicols}\vfill\wpied}

  
  \ifthenelse{\mode= 2 \OR \mode =3}{\end{enonce}\end{multicols}}

  \ifthenelse{\mode = 5}{\vfill\wpied\end{multicols*}}

}


