/*
 *  
 *    
 *  Copyright (C) 2016  Vincent Ledda
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package mastermindSolveur;

import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;


public class solveur extends MamSolveur{
	public solveur(int n,int a){
		super(n,a);
	}
	
	/*
	 * Renvoie la première question
	 * En choisissant au hasard la question, on perd l'assurance d'obtenir le nombre minimal de questions-réponses
	 * @see MamSolveur#init()
	 */
	public String init(){
		this.initPossible();
		int n=ThreadLocalRandom.current().nextInt((int)java.lang.Math.pow(this.A,this.N));
		String propositionInitiale=this.possibles.get(n);
		//String propositionInitiale="AAABB";
		this.currentProposition=propositionInitiale;
		return propositionInitiale;
		
		}
	
	/*
	 * Renvoie la proposition suivante à tester en maximisant le nombre minimum de réponses qui pourraient être éliminées (Knuth).
	 * On cherche un code dans les codes possibles cela accélère la recherche, mais ne garantie pas un nombre minimal de questions.
	 * @see MamSolveur#nextProposition(int[])
	 * @return prochaine proposition
	 */
	public String nextProposition(){
		String nextProposition=this.currentProposition;
		int max=0;
		if(this.possibles.size()>1){
		for(String proposition:this.possibles){
			int min=this.possibles.size();
			for(int[] score:this.resultats){
				int i=0;
				for(String vsecret:this.possibles){
					//System.out.println(Arrays.toString(MmU.testSolution(proposition,vsecret)));
					//System.out.println(Arrays.toString(score));
					if(!Arrays.equals(MmOutils.testSolution(proposition,vsecret),score)){
						i++;
					}
				}
				
				if(i<=min){
					min=i;
				
				}
			
			}
			if(min>=max){
				max=min;
				nextProposition=proposition;
				}
		}
		}
		else{
			nextProposition=this.possibles.get(0);
		}
			
		this.currentProposition=nextProposition;
		return nextProposition;
	
	}
}
