/*
 *  
 *    
 *  Copyright (C) 2016  Vincent Ledda
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package mastermindSolveur;


	import java.util.ArrayList;
	import java.util.Arrays;

	import java.util.Collections;
	public abstract class MamSolveur {
		
		protected int N;
		protected int A;
		protected char [] Alphabet;
		protected String currentProposition;
		protected ArrayList<String> possibles;
		

	/*
	 * Les scores possibles
	 */

		protected int[][] resultats=new int[14][2];
		
		
		
		public MamSolveur(int n,int a) {
			this.N=n;
			this.A=a;
			this.currentProposition="AABB";
			this.Alphabet = MmOutils.genAlphabet(a);
			
			this.possibles=initPossible();
			int k=0;
			for(int i=0;i<5;i++){
				for(int j=0;j<5-i;j++){
					if(!Arrays.equals(new int[] {i,j} ,new int[] {3,1} )){
						this.resultats[k]=new int[] {i,j};
						k++;
					}
						
				}
			}
			
		}
		
		public ArrayList<String> getPossibles(){
			return this.possibles;
		}
		public void updateListes(int[] score){
			ArrayList<String> possibles=new ArrayList<String>(this.possibles);
		
			for(String code:possibles){
				
				if(!Arrays.equals(MmOutils.testSolution(this.currentProposition,code),score))
				{
					this.possibles.remove(code);
					
				}
			}
		}
		
		public ArrayList<String> createListes(int n, ArrayList<String> liste){
			ArrayList<String> resultat = new ArrayList<>();
			ArrayList<String> current=liste;
			while(n>0)
			{	
				for(int i=0;i<current.size();i++){
					for(int j=0;j<this.A;j++){
						resultat.add(current.get(i)+String.valueOf(this.Alphabet[j]));
					}
				}
				n=n-1;
				
				current=new ArrayList<String>(resultat);
				
				resultat.clear();
				}
			
			
			return current;
		}
		
		
		public ArrayList<String> initPossible(){
			String[] possible=new String[(int)java.lang.Math.pow(this.A,this.N)];
			ArrayList<String> nntest=new ArrayList<>();
			nntest.add("");
			return createListes(this.N,nntest);
				}
		
		/*
		 * @param une suite de questions-réponses pour un mastermind
		 * @return les solutions possibles
		 */
			public ArrayList<String> testProbleme(String[] questions,int[][] reponses){
				
				this.possibles=initPossible();
				for(int i=0;i<questions.length;i++){
					if(questions[i].length()==this.N){
						this.currentProposition=questions[i];
						this.updateListes(reponses[i]);
				}	
					}
				
				return this.possibles;
			}	
		
		
		
		public abstract String init();
		public abstract String nextProposition();
		
		
		
	}


