/*
 *  
 *    
 *  Copyright (C) 2016  Vincent Ledda
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import java.util.ArrayList;
import java.util.Arrays;

import mastermindSolveur.MmOutils;
import mastermindSolveur.solveur;

public class mastermind {

private String secret="AAAA";

/*
 * @param N
 * Nombre de lettres de la combinaison
 */
private Integer N;
/*
 * @param A
 * cardinal de l'alphabet
 */

private Integer A;


private char [] Alphabet;
/*
 * Teste la taille de la chaine et si les lettres appartiennent bien à l'alphabet
 * @param la chaine à tester
 * @return vrai si la chaine est correcte faux sinon
 * 
 */




private boolean chaineIsCorrect(String s){
	boolean isCorrect=false;
	if(s.length() == N){
		
		isCorrect=true;
		for(int i=0;i<N;i++){
			int elementPosition = Arrays.binarySearch(this.Alphabet, s.charAt(i) );
			
			if(elementPosition<0){
				System.out.println("La lette "+s.charAt(i)+" n'est pas dans l'alphabet");
				isCorrect=false;
			}
		}
	}
	else{
		System.out.println("Taille incorrecte");
	}
	return isCorrect;	
	
	
	
}

public mastermind(int n,int a) {
	this.N=n;
	this.A=a;
	this.Alphabet=new char[a];
	this.Alphabet=MmOutils.genAlphabet(a);
		
}

private boolean[] positions(String s,char c){
	
	int n=s.length();
	boolean pos []= new boolean[n];
	
	for(int i=0;i<n;i++){
		if(s.charAt(i)==c){
			pos[i]=true;
		}
		else{
			pos[i]=false;
		}
	}
	
		
	return pos;
	
}





public char[] getAlphabet(){
		return this.Alphabet;
		}

public String getSecret(){
			return this.secret;
}
public void setSecret(String s){
	if(chaineIsCorrect(s)){
		this.secret=s;
	}else{
		System.out.println("Le mot secret n'est pas correct");
		System.exit(0);
	}
}






public ArrayList<Object> resoudre(){
	ArrayList<Object> list = new ArrayList();
	solveur sol=new solveur(this.N,this.A);
	ArrayList<String> questions=new ArrayList<String>();
	ArrayList<int[]> reponses=new ArrayList<int[]>();

	int i=0;
	String proposition=sol.init();
	int[] score =MmOutils.testSolution(proposition,this.secret);
	
	questions.add(proposition);
	reponses.add(score);
	i++;
	
	
	while(!Arrays.equals(score, new int[] {this.N,0 })){
		sol.updateListes(score);
		proposition=sol.nextProposition();
		score =MmOutils.testSolution(proposition,this.secret);
		
		if(!Arrays.equals(score,new int[] {this.N,0})){
			questions.add(proposition);
			reponses.add(score);
			i++;
		}
			
		
	
		
		list.add(questions);
		list.add(reponses);
		
}
	return list;
}



}
