/*
 *  
 *    
 *  Copyright (C) 2016  Vincent Ledda
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.SWT;

import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseAdapter;

import org.eclipse.swt.widgets.Text;


public class lmastermind {

	protected Shell shell;
	private Text LeRep;

	/**
	 * Launch the application.
	 * @param args
	 */
	public static void main(String[] args) {
		try {
			lmastermind window = new lmastermind();
			window.open();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * Open the window.
	 */
	public void open() {
		Display display = Display.getDefault();
		createContents();
		shell.open();
		shell.layout();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
	}

	/**
	 * Create contents of the window.
	 */
	protected void createContents() {
		shell = new Shell();
		shell.setSize(681, 302);
		shell.setText("Générateur de mastermind");
		
		Button btnNewButton = new Button(shell, SWT.NONE);
		btnNewButton.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseUp(MouseEvent e) {
				new DirFileSelection(shell);
			}
			
		});
		btnNewButton.setBounds(474, 154, 191, 31);
		btnNewButton.setText("Choisissez un répertoire");
		
		Label lblNewLabel = new Label(shell, SWT.NONE);
		lblNewLabel.setBounds(34, 24, 173, 23);
		lblNewLabel.setText("Nombres de trous");
		
		Spinner spinner = new Spinner(shell, SWT.BORDER);
		spinner.setMaximum(6);
		spinner.setMinimum(4);
		spinner.setSelection(4);
		spinner.setBounds(240, 24, 120, 37);
		
		Label lblNewLabel_1 = new Label(shell, SWT.NONE);
		lblNewLabel_1.setBounds(34, 167, 206, 18);
		lblNewLabel_1.setText("Répertoire de destination");
		
		LeRep = new Text(shell, SWT.BORDER);
		LeRep.setText(System.getProperty("user.home"));
		LeRep.setBounds(240, 154, 206, 31);
		
		Label lblNewLabel_2 = new Label(shell, SWT.NONE);
		lblNewLabel_2.setBounds(34, 72, 131, 18);
		lblNewLabel_2.setText("Nombre de lettres");
		
		Spinner spinner_1 = new Spinner(shell, SWT.BORDER);
		spinner_1.setMaximum(8);
		spinner_1.setMinimum(6);
		spinner_1.setSelection(4);
		spinner_1.setBounds(240, 67, 120, 37);
		
		Label lblNombreDexercices = new Label(shell, SWT.NONE);
		lblNombreDexercices.setText("Nombre d'exercices");
		lblNombreDexercices.setBounds(34, 121, 131, 18);
		
		Spinner spinner_2 = new Spinner(shell, SWT.BORDER);
		spinner_2.setMaximum(10);
		spinner_2.setMinimum(1);
		spinner_2.setSelection(5);
		spinner_2.setBounds(240, 110, 120, 37);
		
		Button btnNewButton_1 = new Button(shell, SWT.NONE);
		btnNewButton_1.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseUp(MouseEvent e) {
				Mmtotex fiche=new Mmtotex(Integer.parseInt(spinner.getText().trim()),Integer.parseInt(spinner_1.getText().trim()),Integer.parseInt(spinner_2.getText().trim()),LeRep.getText());
				fiche.buildFiche();
				
			}
		});
		btnNewButton_1.setBounds(255, 214, 105, 31);
		btnNewButton_1.setText("Go");

	}
}




