/*
 *  
 *    
 *  Copyright (C) 2016  Vincent Ledda
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import java.util.*;
import java.util.regex.Pattern;
import java.util.regex.Matcher;
import java.lang.StringBuilder;
import java.util.Formatter;
import java.util.concurrent.ThreadLocalRandom;
import java.io.FileWriter ;
import java.io.BufferedWriter;

import java.io.IOException;


import mastermindSolveur.*;

public class Mmtotex {

	private Integer N;
	private Integer a;
	private Integer nombreExo;
	private String rep;

	public  Mmtotex(int N,int a, int nombreExo,String rep){
			this.N=N;
			this.a=a;
			this.nombreExo=nombreExo;
			this.rep=rep;
	}

public void buildFiche(){
	int nb=0;
	String nomFichier=String.format(rep+"/mastermind_%d.tex",System.currentTimeMillis() / 1000L);
	
	try {

		
		FileWriter fileWriter = new FileWriter(nomFichier, false);

		
		BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);

		
		
	
	
	
	
	
		boolean agarder;
		mastermind myM=new mastermind(N,a);
	
	
		char[] alphabet=myM.getAlphabet();
	
	
	
	
		StringBuilder builder = new StringBuilder();
		builder.append("\\documentclass[A4,12pt,sol]{cueep}\n%fiche générée aléatoirement\n	\\reference{Tests psychotechniques}\\motsclefs{Mastermind}\\titre{Mastermind}\\usepackage{array,hhline,colortbl}\n		\\definecolor{lightgray}{rgb}{0.6796,0.1445,0.4492}\n		\\begin{document}\nRésolvez les mastermind ci-dessous sur l'alphabet: ");
		builder.append(alphabet[0]);
			for(int i=1;i<a;i++){
				builder.append(", "+alphabet[i]);	
			}	
		builder.append(".\n\n");
		while(nb<nombreExo){
			agarder=true;
			StringBuilder secret=new StringBuilder();
			for(int i=0;i<N;i++){
				secret.append(alphabet[ThreadLocalRandom.current().nextInt(a-1)]);
		}
		
		myM.setSecret(secret.toString());
		ArrayList<Object> resolution=myM.resoudre();
		ArrayList<String> questions=(ArrayList<String>)resolution.get(0);
		ArrayList<int[]> reponses=(ArrayList<int[]>)resolution.get(1);
		int[][] Reponses = new int[reponses.size()][2];
		String[] Questions =new String[questions.size()];
		for(int i=0;i<questions.size();i++){
			Questions[i]=questions.get(i);
			Reponses[i]=reponses.get(i);
			if(Reponses[i][0]==3)
			{
				agarder=false;
			}
		}
		if(agarder){
			solveur sol=new solveur(N,a);
			ArrayList<String> solutions = sol.testProbleme(Questions, Reponses);
			if(solutions.size()==1){
				System.out.println(solutions.get(0)+"  "+secret.toString());
				builder.append(mmLatexExo(Questions,Reponses,myM.getSecret()));
				nb++;
			}
			}
	
		
		
	}
	builder.append("\\end{document}");
	
	bufferedWriter.write(builder.toString());

	bufferedWriter.flush();
	bufferedWriter.close();
	System.out.println("Fichier créé");
	
	
	} catch (IOException ioe) {
		System.err.println("Erreur levée de type IOException au niveau de la méthode "
						+ "writeFile(...) : ");
		ioe.printStackTrace();
	}
}// End writeFile(...)
	
	
	
	
	






public  String mmLatexBloc(String[] questions,int[][] reponses){
	int n=questions[0].length();
	StringBuilder builder = new StringBuilder();
	builder.append("\n\\begin{tabular}[h]{*");
	builder.append(n);
	builder.append("{|c}|>{$}c<{$}}\n\\cline{1-");
	builder.append(n);
	builder.append("}\n");
	
	for(int i=0;i<questions.length;i++){
		
		for(int j=0;j<n;j++){
			builder.append(questions[i].charAt(j)+"&");
			
		}
		builder.append(mmLatexRep(reponses[i]));
		builder.append(String.format("\\tabularnewline\\cline{1-%d}\n",n));
		
		
	}
	builder.append("\\end{tabular}");
	return builder.toString();
	
}
public  String mmLatexRep(int[] reponse){
	StringBuilder builder = new StringBuilder();
	for(int i=0;i<reponse[0];i++){
		builder.append("\\blacktriangle ");
	}
	for(int i=0;i<reponse[1];i++){
		builder.append("\\vartriangle ");
	}
	return builder.toString();
}

public String mmLatexExo(String[] questions,int[][] reponses,String reponse){
	StringBuilder builder = new StringBuilder();
	int n=reponse.length();
	String blocEnonce;
	blocEnonce=mmLatexBloc(questions,reponses);
	builder.append("\\begin{exercice}\\begin{center}\n");
	builder.append(blocEnonce);
	builder.append("\\end{center}\n\\begin{sol}\n Voici la solution de ce mastermind\n\\begin{center}");
	builder.append(blocEnonce.substring(0, blocEnonce.length()-14));
	
	//builder.append(String.format("\\multicolumn{%d}{c}{}\\tabularnewline[-12 pt]\\cline{1-%d}\n",n+1,n));
	
	builder.append(String.format("\\hhline{*{%s}=~}",n));
	for(int j=0;j<n;j++){
		builder.append("\\cellcolor{lightgray}"+reponse.charAt(j)+"&");
	}
	builder.append(String.format("\\tabularnewline\\cline{1-%d}\n",n));
	builder.append("\\end{tabular}\n\\end{center}\n");
	builder.append("\\end{sol}\n");
	builder.append("\\end{exercice}\n");
	return builder.toString();
}






	
	
	
	
	
}



	



