/*
 *  
 *    
 *  Copyright (C) 201666666  Vincent Ledda
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class DirFileSelection {
  
		  Display display = Display.getDefault();
  // the label used to display selected dir/file.
  Label label;
  
  Button buttonSelectDir;
  Button buttonOk;
  
  String selectedDir;
  String fileFilterPath = "/home/";

  public DirFileSelection(Shell parent) {
	final Shell shell = new Shell(parent, SWT.CLOSE);	
    label = new Label(shell, SWT.BORDER | SWT.WRAP);
    
    label.setText("Select a dir/file by clicking the buttons below.");
    buttonOk= new Button(shell, SWT.PUSH);
    buttonOk.setText("Ok");
    buttonSelectDir = new Button(shell, SWT.PUSH);
    buttonSelectDir.setText("Select a directory");
    
    
    buttonSelectDir.addListener(SWT.Selection, new Listener() {
      public void handleEvent(Event event) {
        DirectoryDialog directoryDialog = new DirectoryDialog(shell);
        
        directoryDialog.setFilterPath(selectedDir);
        directoryDialog.setMessage("Please select a directory and click OK");
        
        String dir = directoryDialog.open();
        if(dir != null) {
          label.setText("Selected dir: " + dir);
         
          selectedDir = dir;
        }
      }
    });
    
    shell.addListener(SWT.Close, new Listener()
    {
       @Override
       public void handleEvent(Event event)
       {
          System.out.println("Child Shell handling Close event, about to dispose this Shell");
          shell.dispose();
       }
    }); 
    
    buttonOk.addMouseListener(new MouseAdapter() {
		@Override
		public void mouseUp(MouseEvent e) {
			System.out.println(selectedDir);
			Control controls[] = parent.getChildren();
			Text LeRep= (Text) controls[4];
			LeRep.setText(selectedDir);
			shell.close();
		}
    
    });
		
    label.setBounds(0, 0, 400, 60);
    buttonSelectDir.setBounds(0, 65, 200, 30);
    buttonOk.setBounds(200, 65, 200, 30);

    shell.pack();
    shell.open();
    //textUser.forceFocus();
 // Set up the event loop.
    
  }
    


//  public static void main(String[] args) {
//    new DirFileSelection();
//  }
}

