#!/usr/bin/python
# -*- coding: iso-8859-1  -*-

from math import *


def va(x):
    if abs(trunc(x)-x)<= 0.5:
        s=trunc(x)
    else:
        s=trunc(x)+1
    return s
    


def cosd(x):
    return cos(x*pi/180.0)
def sind(x):
    return sin(x*pi/180.0)
def tand(x):
    return tan(x*pi/180.0)


def prind(x):
    n=int(x/360)
    return x-n*360
    
data2d=open('chute.csv','w')
data3d=open('chute_splot.txt','w')
datamp=open('chute_plot_mpost','w')
datadist=open('chute_distance.csv','w')
datavit=open('chute_vitesse.csv','w')

w=3000*6

#rayon du tube en mtre
r=0.02

#rapport entre r et la distance entre le centre du tube et le centre de rotation du pinceau
d=3.0

#angle maximal
angle=asin(1/d)*180.0/pi

angle=angle/1.5

pas=0.00001

nbcoche=11

g=9.81

temps=[]
centres=[]
for n in range(1,nbcoche+1):
    plage=[]
    t=(360.0*n-angle)/w
    centres.append((360.0*n)/w)
    while(t<(360.0*n+angle)/w):
        plage.append(t)
        #print prind(t*w+180)
        t=t+pas
    temps.append(plage)

points=[]


for plage in temps:
    point=[]
    for t in plage:
        theta=w*t+180.0
        
        delta=(-(r*d*sind(theta))**2+r**2)/(sind(theta))**2
        #print delta
        if delta>0:
            for e in [-1,1]:
                x=(sind(theta))**2*(e*sqrt(delta)-d*r/tand(theta))
                y=x/tand(theta)+d*r
                if y>0:
                    data2d.write(str(r*atan(x/y))+" "+str(g*t**2/2)+"\n")
                    data3d.write(str(y)+" "+str(x)+" "+str(g*t**2/2)+"\n")
                    xx=va(r*atan(x/y)*100000)/1000.0
                    yy=va(g*t**2/2*100000)/1000.0
                    datamp.write("draw ("+str(xx)+"*u,"+str(yy)+"*u);\n")
                  
    points.append(point)

    
distances=[0.0]
vitesses=[]
datadist.write('0.0 0.0\n')

tzero=centres[0]
dzero=g*tzero**2/2

for i in range(1,len(centres)):
    t=centres[i]
    distances.append(va((g*t**2/2-dzero)*1000)/10.0)
    datadist.write(str(i*360.0/w)+" "+str(va((g*t**2/2-dzero)*1000)/10.0)+"\n")


for i in range(len(distances)-1):
    v=w*(distances[i+1]-distances[i])/360
    vitesses.append(v)
    #datavit.write(str((i+0.5)*360.0/w)+" "+str(v)+'\n')
    datavit.write(str((i+1)*360.0/w)+" "+str(v)+'\n')
                    
#print points
data2d.close()
data3d.close()
datamp.close()
datadist.close()
datavit.close()


